package com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 * 雷达图
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RadarChart extends BaseMobileComponent {

    private static final long serialVersionUID = 3049489539327025034L;

    public static final String COMPONENT_TYPE = "CHART_RADAR";

    //名称
    private String title;

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        RadarChart radarChart = new RadarChart();
        radarChart.setComponentId(rawContent.getComponentId());
        radarChart.setTitle(rawContent.getLabel());
        radarChart.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return radarChart;
    }

    @Override
    public String returnComponentType() {
        return RadarChart.COMPONENT_TYPE;
    }
}
