package com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class SubProgressChart extends BaseMobileComponent {

    private static final long serialVersionUID = -2628763542627112620L;

    public static final String COMPONENT_TYPE = "CHART_SUBPROGRESS";

    //名称
    private String title;
    //名称是否可显示
    private Boolean titleVisible = false;
    //路径是否展示
    Boolean routeVisible = true;
    //布局,超出一行时，平铺 1,向右滑动 2，前端在超出一行的情况下再读取这个参数
    private Integer layoutStyle = 1;
    //数据源--表单内生效
    private DataSource dataSource;
    //指标数据
    private List<ChartData> chartData;

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        //单独组件拥有自己的数据源，卡片内的图表数据源来源于卡片,卡片的数据要要么直接配置一个对象，要么配置一个数组默认取数组的第一个元素
        //这个取决于ISV怎么配置数据源
        super.resetCmptMultipleDataSourceData(cmptContext, executeContext, this.dataSource, data);
        //根据schema获取真实的数据
        Object value = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        if (ObjectUtils.isEmpty(value)) {
            setDefaultValue(chartData);
            return;
        }
        Map<String, Object> rawMap;
        if (value instanceof Map) {
            rawMap = JsonUtil.objectToJavaObject(value, new TypeReference<Map<String, Object>>() {
            });
        } else if (value instanceof List) {
            if (!CollectionUtils.isEmpty((List) value)) {
                rawMap = JsonUtil.objectToJavaObject(value, new TypeReference<List<Map<String, Object>>>() {
                }).get(0);
            } else {
                setDefaultValue(chartData);
                return;
            }
        } else {
            //表单内的卡片数据源是其他类型的话直接返回
            setDefaultValue(chartData);
            return;
        }
        for (ChartData chart : chartData) {
            chart.setValue(String.valueOf(rawMap.get(chart.getSchema())));
        }
    }

    public void setDefaultValue(List<ChartData> chartData) {
        chartData.forEach(
                chart -> {
                    chart.setValue("0.5");
                });
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        SubProgressChart subProgressChart = new SubProgressChart();
        subProgressChart.setComponentId(rawContent.getComponentId());
        //将配置中的setting转化成成对象
        Card.DesignerRawCard.Content.SubProgressChartObj subProgressChartObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.SubProgressChartObj.class);
        if (subProgressChartObj != null) {
            subProgressChart.setTitle(subProgressChartObj.getTitle());
            subProgressChart.setTitleVisible(subProgressChartObj.getTitleVisible());
            subProgressChart.setChartData(subProgressChartObj.getChartData());
            subProgressChart.setRouteVisible(subProgressChartObj.getRouteVisible());
            subProgressChart.setLayoutStyle(subProgressChartObj.getLayoutStyle());
        }
        subProgressChart.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return subProgressChart;
    }


    @Override
    public String returnComponentType() {
        return SubProgressChart.COMPONENT_TYPE;
    }
}
