package com.digiwin.mobile.mobileuibot.core.component.custom;

import com.digiwin.mobile.mobileuibot.core.component.BaseGroupMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.layout.ComponentLayoutTypeEnum;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：自定义动态渲染内容组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Custom
 * @Author: Zaregoto
 * @Date: 2021/9/7 21:42
 */
@Data
public class CustomContent extends BaseGroupMobileComponent {
    private static final long serialVersionUID = 6159714064228443627L;
    public static final String COMPONENT_TYPE = "CUSTOM_CONTENT";

    @Override
    public String returnComponentType() {
        return CustomContent.COMPONENT_TYPE;
    }

    private Map<String, Object> customParam;
    private Map<String, Object> sysParam;

    private String code;

    private String title;

    private String subTitle;

    private Action subTitleAction;

    private Integer appLayoutType;

    private Integer limitShowSize;

    private Integer rowSize;

    /**
     * 自定义动态渲染内容调用的RESTful接口地址
     */
    private String url;

    /**
     * 子组件名称，目前用在工作台v2绿色智机的多个customGroup内容渲染时
     */
    private String subComponentName;

    public CustomContent() {
        this.customParam = new HashMap<>();
        this.sysParam = new HashMap<>();
    }

    public static CustomContent create(String locale, String clientId, String iamUserToken,
                                       String digiwinGoodsCode, String url, boolean recommend) {
        CustomContent customContent = new CustomContent();
        customContent.getSysParam().put("locale", locale);
        customContent.getSysParam().put("clientId", clientId);
        customContent.getSysParam().put("iamUserToken", iamUserToken);
        customContent.getSysParam().put("digiwinGoodsCode", digiwinGoodsCode);
        customContent.getSysParam().put("recommend", recommend);
        customContent.setUrl(url);

        return customContent;
    }

    public static CustomContent createEmpty() {
        return new CustomContent();
    }

    public Map<String, Object> getCustomParam() {
        return customParam;
    }

    public void setCustomParam(Map<String, Object> customParam) {
        if (null != customParam && !customParam.isEmpty()) {
            this.customParam = customParam;
        }
    }

    public Map<String, Object> getSysParam() {
        return sysParam;
    }

    public void setSysParam(Map<String, Object> sysParam) {
        if (null != sysParam && !sysParam.isEmpty()) {
            this.sysParam = sysParam;
        }
    }

    @Override
    public ComponentLayoutTypeEnum getComponentLayoutType() {
        return ComponentLayoutTypeEnum.VERTICAL;
    }
}
