package com.digiwin.mobile.mobileuibot.core.component.custom;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：自定义动态渲染内容的请求类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomContentRequest
 * @Author: Zaregoto
 * @Date: 2021/9/7 21:51
 */
public class CustomContentRequest implements Serializable {
    private static final long serialVersionUID = -8839960208987842750L;

    private Map<String, Object> customParam;
    private Map<String, Object> sysParam;

    public CustomContentRequest() {
        this.customParam = new HashMap<>();
        this.sysParam = new HashMap<>();
    }

    public CustomContentRequest(CustomContent customContent) {
        this.customParam = customContent.getCustomParam();
        this.sysParam = customContent.getSysParam();
    }

    /**
     * 创建基于当前对象的请求报文
     * @return
     */
    public String buildRequestPayload() {
        return JsonUtil.javaObjectToJsonString(this);
    }

    public Map<String, Object> getCustomParam() {
        return customParam;
    }

    public void setCustomParam(Map<String, Object> customParam) {
        if (null != customParam && !customParam.isEmpty()) {
            this.customParam = customParam;
        }
    }

    public Map<String, Object> getSysParam() {
        return sysParam;
    }

    public void setSysParam(Map<String, Object> sysParam) {
        if (null != sysParam && !sysParam.isEmpty()) {
            this.sysParam = sysParam;
        }
    }
}
