package com.digiwin.mobile.mobileuibot.core.component.divider;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;

import java.io.Serializable;

/**
 * <p>功能描述：分割线组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Divider
 * @Author: Zaregoto
 * @Date: 2021/6/11 19:36
 */
public class Divider extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = 6956782276069970165L;
    public static final String COMPONENT_TYPE = "DIVIDER";

    private Integer type;

    public Divider() {
    }

    public Divider(Integer type) {
        this.type = type;
    }

    public static Divider create(DividerTypeEnum dividerTypeEnum) {
        return new Divider(dividerTypeEnum.getValue());
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public String returnComponentType() {
        return Divider.COMPONENT_TYPE;
    }
}
