package com.digiwin.mobile.mobileuibot.core.component.floating;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 功能: 浮层组件定义
 *
 * @author: wjw
 * @date: created at 2023/2/27
 */
@Data
@Accessors(chain = true)
public class FloatingLayer extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = -2221101866493228807L;
    public static final String COMPONENT_TYPE = "FLOATING_LAYER";

    /**
     * 默认选中list中哪条数据
     */
    private Integer defaultSelect;
    /**
     * UI展示卡片长度
     */
    private Integer showLength;
    /**
     * 是否显示关闭按钮，页面上的×
     */
    private Boolean showCloseButton;
    /**
     * 卡数据列表
     */
    private List<FloatingLayerData> cardList;

    @Override
    public String returnComponentType() {
        return FloatingLayer.COMPONENT_TYPE;
    }
}
