package com.digiwin.mobile.mobileuibot.core.component.floating;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 功能: 浮层数据结构
 *
 * @author: wjw
 * @date: created at 2023/2/27
 */
@Data
@Accessors(chain = true)
public class FloatingLayerData implements Serializable {
    private static final long serialVersionUID = 3667726166603781274L;
    /**
     * 主题
     */
    private String subject;
    /**
     * 标题
     */
    private String title;
    /**
     * 子标题（项目信息）
     */
    private String subTitle;
    /**
     * 始发地
     */
    private String startAddress;
    /**
     * 目的地
     */
    private String endAddress;
    /**
     * 收货人、卸货人信息
     */
    private String sendOrReceiveTitle;
    /**
     * 完整地址
     */
    private String completeAddress;
    /**
     * 地址
     */
    private Address addressMap;
    /**
     * 地图icon(不填默认不展示)
     */
    private Integer mapIcon;
    /**
     * 联系人
     */
    private String contactName;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 打电话ICON
     */
    private Integer phoneIcon;
    /**
     * 主要按钮
     */
    private List<BottomButtonDigiwinAthena> mainButtonList;
    /**
     * 次要按钮
     */
    private List<BottomButtonDigiwinAthena> subButtonList;
    /**
     * 卡片点击action
     */
    private Action action;

    /**
     * 类型 0：发车卡 1：在途卡
     */
    private Integer taskCardType;
}
