package com.digiwin.mobile.mobileuibot.core.component.graphicdisplay;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.search.Pic;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 图文展示组件
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GraphicDisplay extends BaseMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "GRAPHIC_DISPLAY";
    private static final long serialVersionUID = 6622889757470813949L;


    private List<SmartPreciseSearchField> fields;
    @JsonProperty("pic")
    @JSONField(name = "pic")
    private List<Pic> pics;
    private String title;
    private String subTitle;
    private Action action;
    /**
     * 1.card形式；2.头部居左形式 3.左右外边距24px,上边距0
     */
    private Integer style = 1;

    public static GraphicDisplay create(ZTBDriverVehicle driverVehicle, Integer style,
                                        DigiwinDmcProxyService digiwinDmcProxyService) {
        GraphicDisplay graphicDisplay = new GraphicDisplay();
        graphicDisplay.setTitle(driverVehicle.getLicensePlateNo());
        graphicDisplay.setSubTitle("+" + driverVehicle.getLoadedItemCount());
        graphicDisplay.setStyle(style);
        List<Pic> pics = new ArrayList<>(1);
        Pic pic = new Pic();
        if (StringUtils.hasLength(driverVehicle.getPicFileId())) {
            ShareInfo shareInfo = digiwinDmcProxyService.shareFile(driverVehicle.getPicFileId(), DigiwinDmcConfig.SRM_LOADING_BUCKET);
            pic.setPicUrl(shareInfo.getUrl());
        }
        pics.add(pic);
        graphicDisplay.setPics(pics);
        List<SmartPreciseSearchField> fields = new ArrayList<>(3);
        fields.add(SmartPreciseSearchField.create(driverVehicle.getVehicleType(), 2));
        fields.add(SmartPreciseSearchField.create(driverVehicle.getVehicleLength(), 2));
        if (StringUtils.hasLength(driverVehicle.getDriverMobile())) {
            fields.add(SmartPreciseSearchField.create(driverVehicle.getDriverMobile(), 2, 58908));
        }

        graphicDisplay.setFields(fields);
        Action action = new Action();
        action.setRawData(JsonUtil.objectToJavaObject(driverVehicle, Map.class));
        action.setType(ActionTypeEnum.OPEN_TABS.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_DELIVERY_LOADED_ITEM.toString());
        graphicDisplay.setAction(action);
        return graphicDisplay;
    }

    public static GraphicDisplay createNoSubTitle(ZTBDriverVehicle driverVehicle, Integer style,
                                                  DigiwinDmcProxyService digiwinDmcProxyService) {
        GraphicDisplay graphicDisplay = new GraphicDisplay();
        graphicDisplay.setTitle(driverVehicle.getLicensePlateNo());
        graphicDisplay.setStyle(style);
        List<Pic> pics = new ArrayList<>(1);
        Pic pic = new Pic();
        if (StringUtils.hasLength(driverVehicle.getPicFileId())) {
            ShareInfo shareInfo = digiwinDmcProxyService.shareFile(driverVehicle.getPicFileId(), DigiwinDmcConfig.SRM_LOADING_BUCKET);
            pic.setPicUrl(shareInfo.getUrl());
        }
        pics.add(pic);
        graphicDisplay.setPics(pics);
        List<SmartPreciseSearchField> fields = new ArrayList<>(3);
        fields.add(SmartPreciseSearchField.create(driverVehicle.getVehicleType(), 2));
        fields.add(SmartPreciseSearchField.create(driverVehicle.getVehicleLength(), 2));
        if (StringUtils.hasLength(driverVehicle.getDriverMobile())) {
            fields.add(SmartPreciseSearchField.create(driverVehicle.getDriverMobile(), 2, 58908));
        }
        graphicDisplay.setFields(fields);
        Action action = new Action();
        action.setRawData(JsonUtil.objectToJavaObject(driverVehicle, Map.class));
        action.setType(ActionTypeEnum.OPEN_TABS.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_DELIVERY_LOADED_ITEM.toString());
        graphicDisplay.setAction(action);
        return graphicDisplay;
    }

    @Override

    public String returnComponentType() {
        return GraphicDisplay.COMPONENT_TYPE;
    }
}
