package com.digiwin.mobile.mobileuibot.core.component.group;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.component.BaseGroupMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParamJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.*;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumbNode;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.sign.InputSign;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.*;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.standardentry.ZtbCargoInfoEntry;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleItem;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.layout.ComponentLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.core.component.logistics.Logistics;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbCargoUnloading;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.AsnHeaderResponse;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import com.digiwin.mobile.mobileuibot.task.model.TbdsOpStatusEnum;
import com.digiwin.mobile.mobileuibot.task.model.TbdsParameter;
import com.digiwin.mobile.mobileuibot.task.model.TbdsQueryInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;


/**
 * 自定义分组组件
 *
 * @author zhangjj
 * @date 2022/3/18 2:15 PM
 */
@Data
public class CustomGroup extends BaseGroupMobileComponent<BaseMobileComponent> {
    private static final long serialVersionUID = -7032129632817238084L;
    public static final String COMPONENT_TYPE = "CUSTOM_GROUP";

    /**
     * 录入页面需要放到CUSTOM_GROUP内的组件
     */
    public static final List<String> INSIDE_COMPONENT_LIST = new ArrayList<>();

    static {
        INSIDE_COMPONENT_LIST.add(Field.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(Divider.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputCalendar.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputMultiText.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputNumeric.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputSingleText.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(Attachment.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(Picture.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(ButtonSingleSelect.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputSingleSelect.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(SingleSelectList.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputWindowMultiSelect.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputWindowSingleItem.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputWindowSingleSelect.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputSwitch.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputDateTimePicker.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(InputGroupSingleSelect.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(TextMulti.COMPONENT_TYPE);
        INSIDE_COMPONENT_LIST.add(PageButton.COMPONENT_TYPE);
    }

    /**
     * 分组名称（可能没有名称，该字段为空）
     */
    private String name;
    /**
     * 副标题
     */
    private String subName;
    /**
     * 盛放的其他组件信息
     * 注：v1渲染DSL使用，v2渲染DSL不再使用，转使用父类<code>BaseGroupMobileComponent</code>中的contentGroup字段
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData
     */
    private CustomGroupContent content;
    /**
     * 分组样式。详细见下方枚举类
     *
     * @see CustomGroupStyleTypeEnum
     */
    private Integer styleType;
    /**
     * 隐藏扩展配置
     */
    private HiddenConfig hiddenConfig = new HiddenConfig();
    /**
     * 是否显示更多
     */
    private Boolean useExpand = false;

    /**
     * 点击整个容器动作
     *
     * @return
     */
    private Action action;
    /**
     * 点击查看更多跳转
     */
    private Button viewMore;
    /**
     * 在customgroup里面的按钮对齐方式（目前用于多层布局解析）
     */
    private Integer alignmentType;
    /**
     * 在customgroup里面的按钮个数（目前用于多层布局解析）
     */
    private Integer sizeType;

    /**
     * 指定contentCopy格式体，前端根据该结构体来整体操作新增和删除
     */
    private CustomGroupContent contentCopy;

    /**
     * 新增和删除标识每组的schema后缀,相当每组的唯一标识
     */
    private List<String> initGroupIds;

    /**
     * 是否有详情
     */
    private Boolean hasDetail = false;
    /**
     * 是否有录入
     */
    private Boolean hasEditable = false;

    /**
     * 是否允许新增和删除
     */
    private Boolean autoAddContent = false;

    /**
     * 是否允许左右滑动
     */
    private Boolean isSlide = false;

    /**
     * 仅用于多层布局提交
     */
    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> params;

    /**
     * 创建在途宝已装车
     *
     * @param driverVehicle
     * @return
     */
    public static CustomGroup createZtbDeriveVehicle(ZTBDriverVehicle driverVehicle, DigiwinDmcProxyService digiwinDmcProxyService) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setStyleType(CustomGroupStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue());
        customGroup.setName("");
        CustomGroupContent content = new CustomGroupContent();
        List<UiBotLayout> uiBotLayouts = new ArrayList<>();
        UiBotLayout uiBotLayout = new UiBotLayout();
        uiBotLayout.setType(GraphicDisplay.COMPONENT_TYPE);
        uiBotLayout.setSchema(driverVehicle.getTransportNo());
        uiBotLayouts.add(uiBotLayout);
        content.setLayout(uiBotLayouts);
        UiBotPageData pageData = new UiBotPageData();
        pageData.put(driverVehicle.getTransportNo(), GraphicDisplay.create(driverVehicle, 1, digiwinDmcProxyService));
        content.setPageData(pageData);
        customGroup.setContent(content);
        Action action = new Action();
        action.setRawData(JsonUtil.objectToJavaObject(driverVehicle, Map.class));
        action.setType(ActionTypeEnum.OPEN_TABS.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_DELIVERY_LOADED_ITEM.toString());
        customGroup.setAction(action);
        customGroup.setUseExpand(false);
        return customGroup;
    }

    /**
     * 在途宝已装车货物信息
     *
     * @param ztbCargoUnloadingList
     * @param customGroup
     * @param label
     * @return
     */
    public static CustomGroup createZtbLoadedList(List<ZtbCargoUnloading> ztbCargoUnloadingList,
                                                  CustomGroup customGroup, String label) {
        CustomGroupContent content = customGroup.getContent();
        List<UiBotLayout> layouts = new ArrayList<>(ztbCargoUnloadingList.size());
        UiBotPageData pageData = new UiBotPageData();
        for (int i = 0; i < ztbCargoUnloadingList.size(); i++) {
            String schema = UUIDUtil.getUuid();
            UiBotLayout layout = new UiBotLayout();
            layout.setSchema(schema);
            layout.setType(CustomGroup.COMPONENT_TYPE);
            layouts.add(layout);
            pageData.put(schema, CustomGroup.createZtbLoaded(ztbCargoUnloadingList.get(i), label));
            if (i != ztbCargoUnloadingList.size() - 1) {
                UiBotLayout dividerLayout = new UiBotLayout();
                String dividerSchema = UUIDUtil.getUuid();
                dividerLayout.setSchema(dividerSchema);
                dividerLayout.setType(CustomGroup.COMPONENT_TYPE);
                layouts.add(dividerLayout);
                pageData.put(dividerSchema, CustomGroup.buildDivider(DividerTypeEnum.ELEMENT_DIVIDER.getValue()));
            }
        }
        content.setLayout(layouts);
        content.setPageData(pageData);
        return customGroup;
    }

    private static CustomGroup createZtbLoaded(ZtbCargoUnloading loaded, String label) {
        CustomGroup customGroup = new CustomGroup();
        CustomGroupContent content = new CustomGroupContent();
        customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING_BOTTOM.getValue());
        List<UiBotLayout> layouts = new ArrayList<>(2);
        UiBotPageData pageData = new UiBotPageData();

        UiBotLayout titlelayout = new UiBotLayout();
        titlelayout.setType(Field.COMPONENT_TYPE);
        titlelayout.setSchema(loaded.getItemNo());
        layouts.add(titlelayout);
        pageData.put(loaded.getItemNo(), Field.create("", loaded.getItemNo() + "-" +
                        loaded.getItemName(), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue(),
                3, false));
        UiBotLayout loadLayout = new UiBotLayout();
        String schema = UUIDUtil.getUuid();
        loadLayout.setSchema(schema);
        loadLayout.setType(Field.COMPONENT_TYPE);
        layouts.add(loadLayout);
        pageData.put(schema, Field.createZtbField(label, 2, 1, loaded.getTransportQty() + " " +
                loaded.getUnitName(), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_WITH_18PX.getValue()));
        content.setLayout(layouts);
        content.setPageData(pageData);
        customGroup.setContent(content);
        return customGroup;
    }

    /**
     * APC-异常回报的已完成详情
     *
     * @param titleSchema
     * @param completeSchemas
     * @param completeData
     * @param localeService
     * @param locale
     * @return
     */
    public static CustomGroup createApcDetail(String titleSchema, List<ColumnTag> completeSchemas, Map<String, Object> completeData, LocaleService localeService, String locale) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        customGroup.setName((String) completeData.get(titleSchema));
        CustomGroupContent content = new CustomGroupContent();
        List<UiBotLayout> uiBotLayouts = new ArrayList<>(completeSchemas.size());
        UiBotPageData pageData = new UiBotPageData();
        String uuidSchema = UUIDUtil.getUuid();
        for (ColumnTag tag : completeSchemas) {
            String type = tag.getType();
            String schema = tag.getSchema() + "_" + uuidSchema;
            if (Field.COMPONENT_TYPE.equals(type)) {
                pageData.put(schema, Field.createLabelValueLeftField(
                        tag.getLabel(), (String) completeData.get(tag.getSchema()),
                        2, 1, (String) completeData.get(tag.getSchema())));
            } else if (Attachment.COMPONENT_TYPE.equals(type)) {
                UiBotAttachment attachment = JsonUtil.objectToJavaObject(completeData.get(tag.getSchema()), UiBotAttachment.class);
                if (attachment != null && !CollectionUtils.isEmpty(attachment.getData())) {
                    pageData.put(schema, Attachment.uibotAttachmentparseAttachment(attachment, locale, localeService.getLanguageValue(locale, tag.getLabel())));

                } else {
                    type = Field.COMPONENT_TYPE;
                    pageData.put(schema, Field.createLabelValueLeftField(
                            tag.getLabel(), "-",
                            2, 1, "-"));
                }
            }
            uiBotLayouts.add(new UiBotLayout(schema, type));
        }
        content.setLayout(uiBotLayouts);
        content.setPageData(pageData);
        customGroup.setContent(content);
        customGroup.setUseExpand(false);
        customGroup.setHiddenConfig(new HiddenConfig());
        return customGroup;
    }

    public static CustomGroup createDetail(LocaleService localeService, ApiRequest apiRequest, Map<String, Object> data, CustomGroup customGroup) {
        String locale = apiRequest.getLocale();
        customGroup.setName(localeService.getLanguageValue(locale, customGroup.getName()));
        CustomGroupContent content = customGroup.getContent();
        UiBotPageData pageData = content.getPageData();
        DigiwinMdcProxyService digiwinMdcProxyService = SpringContextHolder.getBean(DigiwinMdcProxyService.class);
        boolean isProductGatewayE10orT100 = digiwinMdcProxyService.isProductGatewayE10orT100(apiRequest.getIamUserToken(), apiRequest.getTenantId());

        Iterator<UiBotLayout> iterator = content.getLayout().iterator();
        while (iterator.hasNext()) {
            UiBotLayout layout = iterator.next();
            String schema = layout.getSchema();
            String type = layout.getType();
            if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                // 产品线为E10或T100才展示特征码
                if ("item_feature_no".equalsIgnoreCase(schema) || "item_feature_spec".equalsIgnoreCase(schema)) {
                    if (!isProductGatewayE10orT100) {
                        iterator.remove();
                        continue;
                    }
                }
                pageData.put(schema, Field.createZtbField(localeService.getLanguageValue(locale, layout.getLabel()),
                        FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                        FieldValueStyleTypeEnum.VALUE_BLACK.getValue(),
                        ModuleUtils.emptyValueToHyphen(data.get(schema)),
                        FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue()));
            } else if (Attachment.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                Map<String, Object> attachData = (Map<String, Object>) data.get(schema);
                if (!CollectionUtils.isEmpty(attachData)) {
                    if (attachData.get("row_data") instanceof Map) {
                        attachData.put("row_data", JsonUtil.javaObjectToJsonString(attachData.get("row_data")));
                    }
                } else {
                    attachData = new HashMap<>(2);
                    attachData.put("data", Collections.emptyList());
                    attachData.put("row_data", "");
                }
                UiBotAttachment attachment = JsonUtil.objectToJavaObject(attachData, UiBotAttachment.class);
                if (attachment == null || CollectionUtils.isEmpty(attachment.getData())) {
                    layout.setType(Field.COMPONENT_TYPE);
                    pageData.put(schema, Field.createZtbField(localeService.getLanguageValue(locale, layout.getLabel()),
                            FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                            FieldValueStyleTypeEnum.VALUE_BLACK.getValue(), "-",
                            FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue()));
                } else {
                    layout.setType(Attachment.COMPONENT_TYPE);
                    pageData.put(schema, Attachment.uibotAttachmentparseAttachment(attachment, locale,
                            localeService.getLanguageValue(locale, layout.getLabel())));
                }
            }
        }
        return customGroup;
    }


    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    @Override
    public ComponentLayoutTypeEnum getComponentLayoutType() {
        return ComponentLayoutTypeEnum.VERTICAL;
    }

    /**
     * 创建一个空的customGroup
     *
     * @param locale
     * @return
     */
    public static CustomGroup createEmptyGroup(String locale, String name) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(name);
        CustomGroupContent content = new CustomGroupContent();
        UiBotModel emptyUibot = UiBotModel.emptyUibotModel(locale);
        content.setLayout(emptyUibot.getLayout());
        content.setPageData(emptyUibot.getPageData());
        customGroup.setContent(content);
        customGroup.setHasDetail(false);
        customGroup.setUseExpand(false);
        customGroup.setHiddenConfig(new HiddenConfig());
        return customGroup;
    }

    public static CustomGroup create(String name, CustomGroupStyleTypeEnum styleTypeEnum) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(name);
        customGroup.setStyleType(styleTypeEnum.getValue());
        customGroup.setHiddenConfig(new HiddenConfig());
        return customGroup;
    }

    public static CustomGroup create(String name, CustomGroupStyleTypeEnum styleTypeEnum, CustomGroupContent customGroupContent) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(name);
        customGroup.setStyleType(styleTypeEnum.getValue());
        customGroup.setContent(customGroupContent);
        customGroup.setHiddenConfig(new HiddenConfig());
        return customGroup;
    }

    public static CustomGroup create(String name, UiBotModel uiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(name);
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setPageData(uiBotModel.getPageData());
        customGroupContent.setLayout(uiBotModel.getLayout());
        customGroup.setContent(customGroupContent);
        customGroup.setHiddenConfig(new HiddenConfig());
        return customGroup;
    }

    /**
     * 在途宝-物流信息(货物发车)
     *
     * @param logisticsUiBotModel
     * @param transportMainInfo
     * @param locale
     * @return
     */
    public CustomGroup buildLogisticsGroup(String locale, DigiwinTransportResponse transportMainInfo,
                                           UiBotModel logisticsUiBotModel, Boolean useAddressBook) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> logisticsLayouts = logisticsUiBotModel.getLayout();
        UiBotPageData logisticsPageData = new UiBotPageData();
        for (UiBotLayout logisticsLayout : logisticsLayouts) {
            String logisticsSchema = logisticsLayout.getSchema();
            switch (logisticsLayout.getType()) {
                case Logistics.COMPONENT_TYPE:
                    logisticsPageData.put(logisticsSchema, Logistics.create(logisticsSchema, locale,
                            transportMainInfo, useAddressBook));
                    break;
                default:
                    break;
            }
        }
        CustomGroupContent logisticsContent = new CustomGroupContent();
        logisticsContent.setLayout(logisticsLayouts);
        logisticsContent.setPageData(logisticsPageData);
        customGroup.setContent(logisticsContent);
        return customGroup;
    }


    /**
     * 在途宝-物流信息(扫描ASN单回填物流)
     *
     * @param useAddressBook
     * @param deliverAddress
     * @param receiptAddress
     * @param locale
     * @return
     */
    public static CustomGroup buildLogisticsGroup(String locale, Map<String, Object> deliverAddress, Map<String, Object> receiptAddress, Boolean useAddressBook) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> logisticsLayouts = new ArrayList<>(1);
        UiBotPageData logisticsPageData = new UiBotPageData();
        UiBotLayout layout = new UiBotLayout();
        layout.setType(Logistics.COMPONENT_TYPE);
        layout.setSchema("logistics");
        logisticsPageData.put("logistics", Logistics.create("logistics", locale,
                deliverAddress, receiptAddress, useAddressBook));
        logisticsLayouts.add(layout);
        CustomGroupContent logisticsContent = new CustomGroupContent();
        logisticsContent.setLayout(logisticsLayouts);
        logisticsContent.setPageData(logisticsPageData);
        customGroup.setContent(logisticsContent);
        return customGroup;
    }

    /**
     * 在途宝-物流信息(货物发车)
     *
     * @param localeService
     * @param useAddressBook
     * @param locale
     * @return
     */
    public static CustomGroup buildEmptyLogisticsGroup(LocaleService localeService, String locale,
                                                       Boolean useAddressBook) {
        CustomGroup customGroup = new CustomGroup();
        UiBotPageData logisticsPageData = new UiBotPageData();
        List<UiBotLayout> uiBotLayouts = new ArrayList<>(1);
        UiBotLayout logisticsLayout = new UiBotLayout();
        logisticsLayout.setSchema(Logistics.COMPONENT_TYPE);
        logisticsLayout.setType(Logistics.COMPONENT_TYPE);
        uiBotLayouts.add(logisticsLayout);
        logisticsPageData.put(Logistics.COMPONENT_TYPE, Logistics.createEmpty(localeService, locale, useAddressBook));
        CustomGroupContent logisticsContent = new CustomGroupContent();
        logisticsContent.setLayout(uiBotLayouts);
        logisticsContent.setPageData(logisticsPageData);
        customGroup.setContent(logisticsContent);
        return customGroup;
    }

    /**
     * 在途宝-物流信息（出库装车）
     *
     * @param logisticsUiBotModel
     * @param asnHeaderResponse
     * @param locale
     * @return
     */
    public CustomGroup buildLogisticsGroup(String locale, AsnHeaderResponse asnHeaderResponse,
                                           UiBotModel logisticsUiBotModel, Boolean useAddressBook) {
        CustomGroup customGroup = new CustomGroup();
        List<UiBotLayout> logisticsLayouts = logisticsUiBotModel.getLayout();
        UiBotPageData logisticsPageData = new UiBotPageData();
        for (UiBotLayout logisticsLayout : logisticsLayouts) {
            String logisticsSchema = logisticsLayout.getSchema();
            switch (logisticsLayout.getType()) {
                case Logistics.COMPONENT_TYPE:
                    logisticsPageData.put(logisticsSchema, Logistics.create(logisticsSchema, locale,
                            asnHeaderResponse, useAddressBook));
                    break;
                default:
                    break;
            }
        }
        CustomGroupContent logisticsContent = new CustomGroupContent();
        logisticsContent.setLayout(logisticsLayouts);
        logisticsContent.setPageData(logisticsPageData);
        customGroup.setContent(logisticsContent);
        return customGroup;
    }

    /**
     * 在途宝的收获规划
     *
     * @param customUiboModel
     * @param localeService
     * @param digiwinEspProxyService
     * @param apiRequest
     * @param transportMainInfo
     * @param transportNo
     * @param taskNo
     * @return
     */
    public UiBotModel buildReceiptPreparation(UiBotModel customUiboModel, LocaleService localeService,
                                              DigiwinEspProxyService digiwinEspProxyService, ApiRequest apiRequest, Map<String, Object> transportMainInfo, String transportNo, String taskNo) {
        UiBotPageData customPageData = customUiboModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        for (UiBotLayout uiBotLayout : customUiboModel.getLayout()) {
            String title = localeService.getLanguageValue(locale, uiBotLayout.getLabel());
            String data = (String) transportMainInfo.get(uiBotLayout.getSchema());
            switch (uiBotLayout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    Map<String, Object> rawData = new HashMap<>(1);
                    rawData.put("isZTB", true);
                    rawData.put("type", "isUserInfo");
                    rawData.put("taskNo", taskNo);
                    rawData.put("transportNo", transportNo);
                    customPageData.put(uiBotLayout.getSchema(), InputWindowSingleSelect.create(title, uiBotLayout.getSchema(),
                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                            locale, rawData, (String) transportMainInfo.get("unloader_id"), data, new RelationRule(), Collections.emptyMap()));
                    break;
                case InputSingleText.COMPONENT_TYPE:
                    customPageData.put(uiBotLayout.getSchema(), InputSingleText.create(uiBotLayout.getSchema(), title,
                            true, true, locale, data, false));
                    break;
                case SingleSelectList.COMPONENT_TYPE:
                    customPageData.put(uiBotLayout.getSchema(), SingleSelectList.createByZtbEnum(
                            digiwinEspProxyService.getEnumerateInfo(
                                    iamUserToken, tenantId, locale, "unloading_time"), title,
                            data, data));
                    break;
                default:
                    break;
            }
        }
        return customUiboModel;
    }

    /**
     * 在途宝的入厂工作
     *
     * @param customUiboModel
     * @param localeService
     * @param locale
     * @param transportMainInfo
     * @param transportNo
     * @param taskNo
     * @return
     */
    public UiBotModel buildTransportComingSoon(UiBotModel customUiboModel, LocaleService localeService, String locale, Map<String, Object> transportMainInfo, String transportNo, String taskNo) {
        UiBotPageData customPageData = customUiboModel.getPageData();
        for (UiBotLayout uiBotLayout : customUiboModel.getLayout()) {
            String title = localeService.getLanguageValue(locale, uiBotLayout.getLabel());
            String data = (String) transportMainInfo.get(uiBotLayout.getSchema());
            switch (uiBotLayout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    Map<String, Object> rawData = new HashMap<>(1);
                    rawData.put("isZTB", true);
                    rawData.put("type", "isUserInfo");
                    rawData.put("taskNo", taskNo);
                    rawData.put("transportNo", transportNo);
                    String unloader_id = StrUtil.toString(ObjectUtil.isEmpty(transportMainInfo.get("unloader_id")) ? "" : transportMainInfo.get("unloader_id"));
                    String unloader_name = StrUtil.toString(ObjectUtil.isEmpty(transportMainInfo.get("unloader_name")) ? "" : transportMainInfo.get("unloader_name"));
                    Map defaultMap = new HashMap();
                    if (StrUtil.isNotBlank(unloader_id) && StrUtil.isNotBlank(unloader_name)) {
                        defaultMap.put("unloader_id", unloader_id);
                        defaultMap.put("unloader_name", unloader_name);
                    }
                    customPageData.put(uiBotLayout.getSchema(), InputWindowSingleSelect.create(title, uiBotLayout.getSchema(),
                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                            locale, rawData, (String) transportMainInfo.get("unloader_id"), data, new RelationRule(), defaultMap));
                    break;
                case InputSingleText.COMPONENT_TYPE:
                    customPageData.put(uiBotLayout.getSchema(), InputSingleText.create(uiBotLayout.getSchema(), title,
                            true, true, locale, data, false));
                    break;
                case InputNumeric.COMPONENT_TYPE:
                    InputNumeric inputNumeric = InputNumeric.create(11, 0, data, title,
                            InputNumericTypeEnum.INTEGER.getValue());
                    inputNumeric.setPlaceholder("请输入...");
                    inputNumeric.setHidden(false);
                    inputNumeric.setRequired(true);
                    customPageData.put(uiBotLayout.getSchema(), inputNumeric);
                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
                    inputDateTimePicker.setSchema(uiBotLayout.getSchema());
                    inputDateTimePicker.setTitle(title);
                    inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
                    inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                            locale,
                            LocaleUtil.getMobileTextByKey(locale, "请选择"),
                            title,
                            "")
                    );
                    inputDateTimePicker.setType(InputDateTimePickerTypeEnum.HOUR_MINUTE.getType());
                    inputDateTimePicker.setEnable(true);
                    inputDateTimePicker.setRequired(true);
                    customPageData.put(uiBotLayout.getSchema(), inputDateTimePicker);
                    break;
                default:
                    break;
            }
        }
        return customUiboModel;
    }

    public static CustomGroup buildDivider(Integer dividerType) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING_BOTTOM.getValue());
        List<UiBotLayout> layouts = new ArrayList<>(1);
        UiBotLayout dividerLayout = new UiBotLayout();
        String dividerSchema = UUIDUtil.getUuid();
        dividerLayout.setSchema(dividerSchema);
        dividerLayout.setType(Divider.COMPONENT_TYPE);
        layouts.add(dividerLayout);
        UiBotPageData pageData = new UiBotPageData();
        pageData.put(dividerSchema, new Divider(dividerType));
        CustomGroupContent content = new CustomGroupContent();
        content.setLayout(layouts);
        content.setPageData(pageData);
        customGroup.setContent(content);
        return customGroup;
    }

    /**
     * 在途宝--预计送货日期
     *
     * @param locale
     * @param layout
     * @param title
     * @param isSubmit
     * @param planArrivalDate
     * @return
     */
    public CustomGroup buildAppointmentDeliveryDate(String locale, UiBotLayout layout,
                                                    String title, Boolean isSubmit, String planArrivalDate) {
        CustomGroup customGroup = new CustomGroup();
        CustomGroupContent content = new CustomGroupContent();
        List<UiBotLayout> layouts = new ArrayList<>(1);
        UiBotLayout uiBotLayout = new UiBotLayout();
        UiBotPageData pageData = new UiBotPageData();
        if (isSubmit) {
            uiBotLayout.setSchema(layout.getSchema());
            uiBotLayout.setType(Field.COMPONENT_TYPE);
            pageData.put(layout.getSchema(), Field.createLabelLeftValueRightField(title, planArrivalDate, FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), 1));
        } else {
            uiBotLayout.setSchema(layout.getSchema());
            uiBotLayout.setType(InputDateTimePicker.COMPONENT_TYPE);
            pageData.put(layout.getSchema(), InputDateTimePicker.createZtbDeliveryDate(uiBotLayout.getSchema(), true,
                    locale, InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType(), title));
        }
        layouts.add(uiBotLayout);
        content.setLayout(layouts);


        content.setPageData(pageData);
        customGroup.setContent(content);
        return customGroup;
    }

    /**
     * 在途宝--预计送货日期
     *
     * @param locale
     * @param title
     * @return
     */
    public static CustomGroup buildEmptyAppointmentDeliveryDate(String locale, String title) {
        CustomGroup customGroup = new CustomGroup();
        CustomGroupContent content = new CustomGroupContent();
        List<UiBotLayout> layouts = new ArrayList<>(1);
        UiBotLayout uiBotLayout = new UiBotLayout();
        uiBotLayout.setSchema("plan_arrival_date");
        uiBotLayout.setType(InputDateTimePicker.COMPONENT_TYPE);
        layouts.add(uiBotLayout);
        content.setLayout(layouts);

        UiBotPageData pageData = new UiBotPageData();
        pageData.put("plan_arrival_date", InputDateTimePicker.createZtbDeliveryDate(uiBotLayout.getSchema(), true,
                locale, InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType(), title));
        content.setPageData(pageData);
        customGroup.setContent(content);
        return customGroup;
    }

    /**
     * 在途宝-货物信息录入
     *
     * @param locale
     * @param localeService
     * @return
     */
    public static CustomGroup buildEmptyInputZtbCargoInfoEntry(String locale, LocaleService localeService) {
        CustomGroup customGroup = new CustomGroup();
        CustomGroupContent content = new CustomGroupContent();
        List<UiBotLayout> layouts = new ArrayList<>(1);
        UiBotLayout uiBotLayout = new UiBotLayout();
        uiBotLayout.setSchema("delivery_detail_list");
        uiBotLayout.setType(ZtbCargoInfoEntry.COMPONENT_TYPE);
        layouts.add(uiBotLayout);
        content.setLayout(layouts);

        UiBotPageData pageData = new UiBotPageData();
        pageData.put("delivery_detail_list", ZtbCargoInfoEntry.createZtbCargoInformation(locale, localeService, "delivery_detail_list"));
        content.setPageData(pageData);
        customGroup.setContent(content);
        return customGroup;
    }

    public CustomGroup buildPlatformMessage(Map<String, Object> transportMainInfo,
                                            UiBotModel customUiboModel, ApiRequest apiRequest,
                                            LocaleService localeService, String deliveryNo) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(localeService.getLanguageValue(apiRequest.getLocale(), customUiboModel.getName()));
        CustomGroupContent content = new CustomGroupContent();
        UiBotPageData customPageData = customUiboModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        for (UiBotLayout uiBotLayout : customUiboModel.getLayout()) {
            String title = localeService.getLanguageValue(locale, uiBotLayout.getLabel());
            String data;
            Map<String, Object> rawData = new HashMap<>(3);
            RelationRule relationRule = new RelationRule();
            switch (uiBotLayout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    data = (String) transportMainInfo.get(uiBotLayout.getSchema());
                    Map<String, Object> detail = new HashMap<>(2);
                    detail.put(uiBotLayout.getSchema(), data);
                    detail.put("platform_name", transportMainInfo.get("platform_name"));
                    //1、月台编号变化时，清空预计送货时段已选项，且可用
                    relationRule.addCommonRule(buildEnableRule("time_slot"));
                    //2、月台编号清空时，清空预计送货时段已选项，且不可用
                    relationRule.addCommonRule(buildDisableRule("time_slot"));
                    rawData.put("isZTB", true);
                    rawData.put("delivery_no", deliveryNo);
                    rawData.put("type", "isPlatformMessageNo");
                    customPageData.put(uiBotLayout.getSchema(), InputWindowSingleSelect.create(title, uiBotLayout.getSchema(),
                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                            locale, rawData, data, data, relationRule, detail));
                    break;
                case SingleSelectList.COMPONENT_TYPE:
                    rawData.put("isZTB", true);
                    rawData.put("delivery_no", deliveryNo);
                    if ("appointment_delivery_date".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        data = (String) transportMainInfo.get(uiBotLayout.getSchema());
                        //1、预计送货日期变化时，清空月台编号和预计送货时段已选项，且可用
                        relationRule.addCommonRule(buildEnableRule("time_slot"));
                        relationRule.addCommonRule(buildEnableRule("platform_no"));
                        //2、预计送货日期清空时，清空月台编号和预计送货时段已选项，且不可用
                        relationRule.addCommonRule(buildDisableRule("time_slot"));
                        relationRule.addCommonRule(buildDisableRule("platform_no"));
                        rawData.put("type", "isAppointmentDeliveryDate");

                        customPageData.put(uiBotLayout.getSchema(), SingleSelectList.createOnText(title,
                                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                data, data, rawData, SingleSelectListTypeEnum.PROGRESS_REPORT.getValue()
                                , relationRule));
                    } else if ("time_slot".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        List<Map<String, Object>> timeSlots = (List<Map<String, Object>>) transportMainInfo.get(uiBotLayout.getSchema());
                        List<String> textList;
                        if (timeSlots != null && timeSlots.size() > 0) {
                            textList = new ArrayList<>(timeSlots.size());
                        } else {
                            textList = new ArrayList<>(0);
                        }
                        for (Map<String, Object> timeSlot : timeSlots) {
                            textList.add(timeSlot.get("appointment_delivery_time_start") + "~" + timeSlot.get("appointment_delivery_time_end"));
                        }

                        rawData.put("type", "isTimeSlot");
                        customPageData.put(uiBotLayout.getSchema(), SingleSelectList.createOnTexts(title,
                                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                textList, textList, rawData, SingleSelectListTypeEnum.BOTTOM_OPTION.getValue()));
                    }
                    break;
                default:
                    break;
            }
        }
        content.setLayout(customUiboModel.getLayout());
        content.setPageData(customPageData);
        customGroup.setContent(content);
        return customGroup;
    }

    private CommonRule buildEnableRule(String schema) {
        CommonRule sourceNameRule = new CommonRule();
        sourceNameRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        sourceNameRule.setTargetSchema(schema);
        sourceNameRule.setTargetSelectId("");
        sourceNameRule.setTargetEnable(true);
        sourceNameRule.setTargetHidden(false);
        return sourceNameRule;
    }

    private CommonRule buildDisableRule(String schema) {
        CommonRule sourceNameRule = new CommonRule();
        sourceNameRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_EMPTY.getType());
        sourceNameRule.setTargetSchema(schema);
        sourceNameRule.setTargetSelectId("");
        sourceNameRule.setTargetText("");
        sourceNameRule.setTargetEnable(false);
        return sourceNameRule;
    }

    @Override
    public void initSetting(String locale) {
        if (StringUtils.hasLength(this.getName())) {
            this.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, this.getName()));
        }
        if (this.getContent() != null) {
            List<UiBotLayout> layoutList = content.getLayout();
            UiBotPageData pageData = content.getPageData();
            if (!CollectionUtils.isEmpty(layoutList)) {
                layoutList.forEach(layout -> {
                    switch (layout.getType()) {
                        case AppEntrance.COMPONENT_TYPE:
                            AppEntrance appEntrance = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), AppEntrance.class);
                            appEntrance.initSetting(locale);
                            pageData.put(layout.getSchema(), appEntrance);
                            break;
                        case Empty.COMPONENT_TYPE:
                            Map<String, Object> empty = (Map<String, Object>)
                                    pageData.get(layout.getSchema());
                            empty.put("text", LocaleUtil.getMobileTextByDatabaseKey(locale,
                                    (String) empty.get("text")));
                            pageData.put(layout.getSchema(), empty);
                            break;
                        default:
                            break;
                    }
                });
            }
        }
    }

    /**
     * 在途宝上传图片
     *
     * @param locale
     * @param localeService
     * @param schema
     * @param required
     * @return
     */
    public CustomGroup buildZtbPictrue(String picTitle, String locale, LocaleService localeService, String schema, Boolean required, String palceholder) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        List<UiBotLayout> uiBotLayouts = new ArrayList<>(1);
        UiBotPageData pageData = new UiBotPageData();
        uiBotLayouts.add(new UiBotLayout(schema, Picture.COMPONENT_TYPE));
        Picture picture = Picture.createEmptyPic(schema, localeService.getLanguageValue(locale, picTitle),
                AttachmentTypeEnum.READ_AND_WRITE.getValue(), required, "driver_vehicle_img");
        picture.setPlaceholder(localeService.getLanguageValue(locale, palceholder));
        pageData.put(schema, picture);
        CustomGroupContent content = new CustomGroupContent();
        content.setPageData(pageData);
        content.setLayout(uiBotLayouts);
        customGroup.setContent(content);
        customGroup.setHiddenConfig(new HiddenConfig());
        customGroup.setUseExpand(false);
        customGroup.setHasDetail(false);
        return customGroup;
    }

    /**
     * 在途宝签字上传
     *
     * @param locale
     * @param localeService
     * @param schema
     * @param required
     * @return
     */
    public CustomGroup buildZtbSign(String title, String locale, LocaleService localeService, String schema, Boolean required, String palceholder) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        List<UiBotLayout> uiBotLayouts = new ArrayList<>(1);
        UiBotPageData pageData = new UiBotPageData();
        uiBotLayouts.add(new UiBotLayout(schema, InputSign.COMPONENT_TYPE));
        InputSign inputSign =
                InputSign.create(locale, title, schema, new HashMap<>(),
                        Collections.emptyList());
        // 因此任务为定制，签名字段必填属性需单独设置
        inputSign.setRequired(true);
        pageData.put(schema, inputSign);
        CustomGroupContent content = new CustomGroupContent();
        content.setPageData(pageData);
        content.setLayout(uiBotLayouts);
        customGroup.setContent(content);
        customGroup.setHiddenConfig(new HiddenConfig());
        customGroup.setUseExpand(false);
        customGroup.setHasDetail(false);
        return customGroup;
    }

    public CustomGroup buildPageButton(String schema, String paegButtonName, Map<String, Object> rawData) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        List<UiBotLayout> uiBotLayouts = new ArrayList<>(1);
        UiBotPageData pageData = new UiBotPageData();
        uiBotLayouts.add(new UiBotLayout(schema, PageButton.COMPONENT_TYPE));
        PageButton pageButton = new PageButton();
        pageButton.setName(paegButtonName);
        Action action = new Action();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_CARGO_INFORMATION_LIST.toString());
        action.setJumpPageTitle(paegButtonName);
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setRawData(rawData);
        pageButton.setAction(action);
        pageData.put(schema, pageButton);
        CustomGroupContent content = new CustomGroupContent();
        content.setPageData(pageData);
        content.setLayout(uiBotLayouts);
        customGroup.setContent(content);
        customGroup.setHiddenConfig(new HiddenConfig());
        customGroup.setUseExpand(false);
        customGroup.setHasDetail(false);
        return customGroup;
    }

    public CustomGroup buildTbdsItemList(CustomGroup customGroup, String locale
            , LocaleService localeService, List<Map<String, Object>> itemList,
                                         Map<String, Object> commonRawData
            , DigiwinAtdmProxyService digiwinAtdmProxyService, ApiRequest apiRequest,
                                         Boolean hasButton, Boolean noCrumb, Boolean isRecipt) {
        int crumbLength = 1;
        if (apiRequest.getCrumbLength() != null) {
            crumbLength = apiRequest.getCrumbLength();
        } else {
            if (apiRequest.getRawData().get("crumbLength") != null) {
                crumbLength = (int) apiRequest.getRawData().get("crumbLength");
            }
        }
        CustomGroupContent content = customGroup.getContent();
        UiBotLayout templeteLayout = content.getLayout().get(0);
        if (CollectionUtils.isEmpty(itemList)) {
            return CustomGroup.createEmptyGroup(locale, customGroup.getName());
        }
        List<UiBotLayout> layouts = new ArrayList<>(itemList.size());
        UiBotPageData newPageData = new UiBotPageData();
        UiBotPageData pageData = content.getPageData();
        Card card = JsonUtil.objectToJavaObject(pageData.get(templeteLayout.getSchema()), Card.class);
        List<CardContent> contents = card.getContent();
        Object p;
        if (commonRawData.get("newParameter") == null) {
            p = commonRawData.get("parameter");
        } else {
            p = commonRawData.get("newParameter");
        }
        if (p == null) {
            p = commonRawData.get("currentNewParameter_" + crumbLength);
        }
        TbdsParameter parameter = JsonUtil.objectToJavaObject(p, TbdsParameter.class);
        itemList.forEach(item -> {
            String schema = "card_" + UUIDUtil.getUuid();
            String breadName = (String) item.get("item_name");
            UiBotLayout layout = new UiBotLayout(schema, templeteLayout.getType());
            layouts.add(layout);
            Card itemCard = new Card();
            String title = (String) item.get(card.getTitle());
            if (StringUtils.hasLength(title)) {
                //TODO 需要跳转下一页
                Action titleAction = new Action();
                Map<String, Object> rawData = new HashMap<>(2);
                Boolean isRecipe = item.get("is_recipe").equals(ModuleUtils.YES);
                if (isRecipe) {
                    breadName += "（配方）";
                } else {
                    breadName += "（材料）";
                }
                rawData.putAll(commonRawData);
                rawData.put("breadName", breadName);
                rawData.put("is_recipe", isRecipe);

                TbdsParameter newParameter = new TbdsParameter();
                for (TbdsQueryInfo info : parameter.getQueryInfo()) {
                    TbdsQueryInfo newTbdsQueryInfo = new TbdsQueryInfo();
                    BeanUtils.copyProperties(info, newTbdsQueryInfo);
                    newTbdsQueryInfo.setProjectNo(MapUtils.getString(rawData, "project_no"));
                    newParameter.getQueryInfo().add(newTbdsQueryInfo);
                }
                newParameter.getQueryInfo().get(0).setParentSeq((String) item.get("item_list_seq"));
                rawData.put("newParameter", newParameter);
                rawData.put("nodeNo", commonRawData.get("nodeNo"));
                titleAction.setRawData(rawData);

                // 查看是否有数据 能不能点击去到下一个页面
                DigiwinAtdmRequest request = DigiwinAtdmRequest.create("bm.opsc.trial.production.complete.get",
                        (Map<String, Object>) JsonUtil.objectToJavaObject(rawData.get("newParameter"), Map.class)
                        , (Map<String, Object>) commonRawData.get("executeContext"),
                        (Map<String, Object>) ((Map<String, Object>) commonRawData.get("executeContext")).get("businessUnit"));
                List<Map<String, Object>> opDatas = digiwinAtdmProxyService.tbdsDataQueryByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(),
                        JsonUtil.javaObjectToJsonString(request), apiRequest.getTenantId());
                if (CollUtil.isEmpty(opDatas)) {
                    itemCard.setTitle(title);
                } else {
                    itemCard.setTitle(title + " >");
                    if (noCrumb) {
                        titleAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                        titleAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_NEXT_STEP.toString());
                        titleAction.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_NEXT_STEP.toString());
                        itemCard.setTitleAction(titleAction);
                    } else {
                        titleAction.setType(ActionTypeEnum.REFRESH_LOCAL.getValue());
                        BreadCrumbNode crumbNode = new BreadCrumbNode();
                        crumbNode.setTitle(breadName);
                        crumbNode.setRequestUrl("/mobile/v1/proxy/get/breadCrumb/data");
                        crumbNode.setColor("");
                        crumbNode.setRawData(rawData);
                        titleAction.setCrumbItem(crumbNode);
                        titleAction.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_NEXT_STEP.toString());
                        itemCard.setTitleAction(titleAction);
                    }

                }


            } else {
                itemCard.setTitle("-");
            }
            List<CardContent> newContents = itemCard.getContent();
            contents.forEach(templeteContent -> {
                CardContent newContent = new CardContent();
                newContent.setLabel(localeService.getLanguageValue(locale, templeteContent.getLabel()));
                newContent.setValue(ModuleUtils.dealValue(item.get(templeteContent.getSchema()), locale, localeService));
                newContents.add(newContent);
            });
            if (hasButton) {
                Action action = new Action();
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_MODIFY_MATERIAL.toString());
                action.setJumpPageTitle(localeService.getLanguageValue(locale, "编辑物料"));
                action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD.toString());
                Map<String, Object> rawData = new HashMap<>(1);
                rawData.put("newParameter", commonRawData.get("newParameter"));
                rawData.put("data", item);
                rawData.put("breadRecipt", isRecipt);
                rawData.put("breadName", breadName);
                rawData.put("nodeNo", commonRawData.get("nodeNo"));
                action.setRawData(rawData);
                itemCard.getButtonList().add(BottomButtonDigiwinAthena.createEditButton(localeService.getLanguageValue(locale, "编辑"), action));
            }
            newPageData.put(schema, itemCard);
        });
        content.setLayout(layouts);
        content.setPageData(newPageData);
        return customGroup;
    }

    public CustomGroup buildTbdsResult(CustomGroup customGroup, String locale, LocaleService localeService, Map<String, Object> opData) {

        CustomGroupContent content = customGroup.getContent();
        List<UiBotLayout> layouts = content.getLayout();
        UiBotPageData pageData = content.getPageData();
        for (UiBotLayout layout : layouts) {
            String schema = layout.getSchema();
            String type = layout.getType();
            if (Attachment.COMPONENT_TYPE.equals(type)) {
                List<Map<String, Object>> documentInfo = (List<Map<String, Object>>) opData.get(schema);
                if (!CollectionUtils.isEmpty(documentInfo)) {
                    List<Map<String, Object>> files =
                            documentInfo.stream()
                                    .map(map -> Optional
                                            .ofNullable((Map<String, Object>) map.get("attachment"))
                                            .map(attachment -> (List<Map<String, Object>>) attachment.get("data"))
                                            .orElse(new ArrayList<>()))
                                    .flatMap(Collection::stream)
                                    .collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(files)) {
                        pageData.put(schema, Attachment.createTbdsFiles(files,
                                AttachmentTypeEnum.READ_ONLY.getValue(),
                                localeService.getLanguageValue(locale, layout.getLabel()), AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue(), "CTP", SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue()));
                        continue;
                    }
                }
                layout.setType(Field.COMPONENT_TYPE);
                pageData.put(schema, Field.createZtbField(
                        localeService.getLanguageValue(locale, layout.getLabel()),
                        FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                        FieldValueStyleTypeEnum.VALUE_BLACK.getValue(), "-",
                        FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX.getValue()));
            } else if (Field.COMPONENT_TYPE.equals(type)) {
                String value;
                // 试验过程记录的数据且为已完成 或者 状态为检测完成 都展示检测完成
                if ((!"0".equals(opData.get("is_associate_project")) && TbdsOpStatusEnum.COMPLETED.getValue().equals(Integer.valueOf((String) opData.get(schema))))
                        || TbdsOpStatusEnum.TEST_COMPLETED.getValue().equals(Integer.valueOf((String) opData.get(schema)))) {
                    value = TbdsOpStatusEnum.TEST_COMPLETED.getName();
                } else {
                    value = TbdsOpStatusEnum.TEST_IN_PROGRESS.getName();
                }
                pageData.put(schema, Field.createZtbField(
                        localeService.getLanguageValue(locale, layout.getLabel()),
                        FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                        FieldValueStyleTypeEnum.VALUE_BLACK.getValue(), value,
                        FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX.getValue()));
            } else if (ButtonSingleSelect.COMPONENT_TYPE.equals(type)) {
                pageData.put(schema, ButtonSingleSelect.createByTbds(layout, localeService, locale, opData.get(schema)));
            }
        }
        return customGroup;
    }

    public CustomGroup buildTbdsParams(CustomGroup customGroup, List<Map<String, Object>> parameterDatas, String locale) {
        List<UiBotLayout> newLayouts = new ArrayList<>(parameterDatas.size());
        UiBotLayout layout = customGroup.getContent().getLayout().get(0);
        UiBotPageData pageData = customGroup.getContent().getPageData();
        for (Map<String, Object> parameterData : parameterDatas) {
            String schema = (String) parameterData.get("parameter_no");
            String label = ModuleUtils.emptyValueToHyphen(parameterData.get(layout.getLabel()));
            UiBotLayout uiBotLayout = new UiBotLayout(schema, InputSingleText.COMPONENT_TYPE);
            String flag = parameterData.get(layout.getMBizKey()) == null ? "N" : (String) parameterData.get(layout.getMBizKey());
            newLayouts.add(uiBotLayout);
            pageData.put(schema, InputSingleText.create(schema, label,
                    !flag.equalsIgnoreCase("N"), true, locale,
                    (String) parameterData.get(layout.getSchema()), false));
        }
        customGroup.getContent().setLayout(newLayouts);
        return customGroup;
    }

    /**
     * 工时回报任务-已上线 Tab卡片创建
     *
     * @param apiRequest
     * @param pcUiBotModel
     * @param mainDataInfo
     * @param detailDataList
     * @param hasButton
     * @param leftTitleFields
     * @param contentFields
     * @param contentFieldCreateLimit
     * @param valueToTextMap
     * @param isCheckIn
     * @param qtyInfoList
     * @return CustomGroup
     * @author yanfeng
     */
    public static CustomGroup create(ApiRequest apiRequest, UiBotModel pcUiBotModel, Map<String, Object> mainDataInfo, List<Map<String, Object>> detailDataList,
                                     boolean hasButton, String[] leftTitleFields, String[] contentFields, int contentFieldCreateLimit,
                                     Map<String, String> valueToTextMap, Boolean isCheckIn, List<Map<String, Object>> qtyInfoList,
                                     Map<String, Object> variableListSimpleMap) {
        CustomGroup customGroup = new CustomGroup();
        CustomGroupContent content = new CustomGroupContent();
        UiBotPageData pageData = new UiBotPageData();
        List<UiBotLayout> uiBotLayouts = new ArrayList<>(1);

        LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);
        String locale = apiRequest.getLocale();
        boolean isTeamTask = apiRequest.getRawData().getBooleanValue("isTeamTask");

        int contentFieldCreatedCount = 0;
        UiBotLayout pcUiBotLayout = new UiBotLayout();
        for (UiBotLayout item : pcUiBotModel.getLayout()) {
            String pcUiBotLayoutType = item.getType() == null ? "" : item.getType();
            String pcUiBotLayoutSchema = item.getSchema() == null ? "" : item.getSchema();
            if ((pcUiBotLayoutType.equalsIgnoreCase("apc_working_hour-task-detail-waitting") && pcUiBotLayoutSchema.equalsIgnoreCase("customData"))
                    || (pcUiBotLayoutType.equalsIgnoreCase("apc_hour_support-task-detail-waitting") && pcUiBotLayoutSchema.equalsIgnoreCase("customData"))
            ) {
                pcUiBotLayout = item;
            }
        }
        List<UiBotAction> pcButtonActions = pcUiBotLayout.getActions();
        ApiExtraParameter newApiExtraParameter = new ApiExtraParameter();
        newApiExtraParameter.setForItemDetail(true);
        ApiRawData newApiRawData = new ApiRawData();
        newApiRawData.put("taskInfo", mainDataInfo);
        // 如果是团队任务，则任务需只读，不能可给用户操作的按钮
        newApiRawData.put("isTeamTask", isTeamTask);
        if (detailDataList.size() == 1) {
            Map<String, Object> detailData = detailDataList.get(0);
            // 子制程参数
            String subOpSeq = String.valueOf(detailData.getOrDefault("sub_op_seq", ""));
            String subOpName = String.valueOf(detailData.getOrDefault("sub_op_name", ""));
            if (!StringUtils.hasLength(subOpSeq) && !StringUtils.hasLength(subOpName)) {
                newApiRawData.put("wo_op_report_data", Collections.emptyList());
            } else {
                newApiRawData.put("wo_op_report_data", detailDataList);
            }
        } else {
            newApiRawData.put("wo_op_report_data", detailDataList);
        }
        List<String> leftTitle = new ArrayList<>();
        // 标题字段
        for (String leftTitleField : leftTitleFields) {
            String value = String.valueOf(mainDataInfo.getOrDefault(leftTitleField, ""));
            if (value.trim().isEmpty()) {
                // 只读的话，空值，移动不显示，故不处理
                continue;
            }
            value = valueToTextMap.getOrDefault(leftTitleField + "_" + value, value);
            leftTitle.add(localeService.getLanguageValue(locale, value));
        }
        for (String contentField : contentFields) {
            String value = String.valueOf(mainDataInfo.getOrDefault(contentField, ""));
            if (value.trim().isEmpty()) {
                // 只读的话，空值，移动不显示，故不处理
                continue;
            }
            value = valueToTextMap.getOrDefault(contentField + "_" + value, value);
            if ("production_status".equalsIgnoreCase(contentField)) {
                value = localeService.getLanguageValue(locale, value);
            }

            String labelStr = valueToTextMap.getOrDefault(contentField, contentField);

            Field field = Field.createLabelLeftValueRightField(localeService.getLanguageValue(locale, labelStr), value);
            uiBotLayouts.add(new UiBotLayout(contentField, Field.COMPONENT_TYPE));
            pageData.put(contentField, field);
            contentFieldCreatedCount++;
            if (contentFieldCreatedCount == contentFieldCreateLimit) {
                break;
            }
        }
        //report_qty 报工数量
        if (!CollectionUtils.isEmpty(qtyInfoList)) {
            List<Integer> reportQtyList = qtyInfoList.stream().map(e -> (Integer) e.get("report_qty")).sorted(Collections.reverseOrder()).collect(Collectors.toList());
            SingleSelectList singleSelectList = new SingleSelectList();
            List<SingleSelectListOption> optionList = new ArrayList<>();
            for (int i = 0; i < reportQtyList.size(); i++) {
                boolean selected = (reportQtyList.get(i) == Double.valueOf(String.valueOf(mainDataInfo.get("report_qty"))).intValue());
                optionList.add(SingleSelectListOption.create(reportQtyList.get(i), selected, false, 0, org.apache.commons.lang3.StringUtils.EMPTY, org.apache.commons.lang3.StringUtils.EMPTY));
            }
            singleSelectList.setTitle(localeService.getLanguageValue(locale, "报工数量"));
            singleSelectList.setStyle(SingleSelectListTypeEnum.PROGRESS_REPORT.getValue());
            singleSelectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
            singleSelectList.setOptionList(optionList);
            singleSelectList.setRequired(false);
            uiBotLayouts.add(new UiBotLayout("report_qty", SingleSelectList.COMPONENT_TYPE));
            pageData.put("report_qty", singleSelectList);
        }
        //当web端attachment参数存在时，则生成图示需要的组件信息。
        if (ObjectUtils.isNotEmpty(mainDataInfo.get("attachment"))) {
            Map<String, Object> map = JsonUtil.objectToJavaObject(mainDataInfo.get("attachment"), new TypeReference<Map<String, Object>>() {
            });
            if (ObjectUtils.isNotEmpty(map.get("data"))) {
                Picture attachment = Picture.create((Map<String, Object>) mainDataInfo.get("attachment"), locale, apiRequest);
                attachment.setTitle(localeService.getLanguageValue(locale, "缩略图"));
                attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                uiBotLayouts.add(new UiBotLayout("attachment", Picture.COMPONENT_TYPE));
                pageData.put("attachment", attachment);
            }
        }

        // 制令备注字段
        UiBotLayout dispatchRemarkUiBotLayout = new UiBotLayout("dispatch_remark", Field.COMPONENT_TYPE);
        uiBotLayouts.add(dispatchRemarkUiBotLayout);
        String dispatchRemarklabelValue = (String) MapUtil.getOrDefault(mainDataInfo, dispatchRemarkUiBotLayout.getSchema(), "");
        Field field = Field.createLabelLeftValueRightField(localeService.getLanguageValue(locale, "制令备注"), dispatchRemarklabelValue);
        pageData.put(dispatchRemarkUiBotLayout.getSchema(), field);

        // 备注字段
        UiBotLayout remarkUiBotLayout = new UiBotLayout("remark", InputMultiText.COMPONENT_TYPE);
        uiBotLayouts.add(remarkUiBotLayout);
        String remarklabelValue = (String) MapUtil.getOrDefault(mainDataInfo, remarkUiBotLayout.getSchema(), "");
        InputMultiText inputMultiText = InputMultiText.create(remarkUiBotLayout.getSchema(),
                localeService.getLanguageValue(locale, localeService.getLanguageValue(locale, "备注")),
                remarklabelValue, true, false, true, locale, 255);
        pageData.put(remarkUiBotLayout.getSchema(), inputMultiText);

        //封装按钮需要的
        UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
        Map<String, Object> businessUnit = (Map<String, Object>) executeContext.get("businessUnit");
        Map<String, Object> commonRawDataMap = new HashMap<>();
        commonRawDataMap.put("businessUnit", businessUnit);
        commonRawDataMap.put("executeContext", executeContext);
        List<BottomButtonDigiwinAthena> buttonList = new ArrayList<>();
        if (isCheckIn) {
            Map<String, Object> woOpReportWorkHours = new HashMap<>();
            woOpReportWorkHours.putAll(mainDataInfo);
            woOpReportWorkHours.putAll(businessUnit);

            // 附件历程和上传附件按钮,目前工时回报加，工时支援不用加
            if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST.name().equalsIgnoreCase(apiRequest.getPageId())) {
                // 异常回报允许上传附件开关打开，才展示附件历程和上传附件两个按钮
                BottomButtonDigiwinAthena attachmentButton = BottomButtonDigiwinAthena.buildAttachmentButtons(woOpReportWorkHours, variableListSimpleMap, locale);
                if (Objects.nonNull(attachmentButton)) {
                    buttonList.add(attachmentButton);
                }
            }

            //已上线需要显示:取消上线按钮
            Map<String, Object> cancelOnlineRawData = new HashMap<>();
            Map<String, Object> cancelOnlineParameter = new HashMap<>();
            List<Map<String, Object>> woOpReportWorkHoursList = new ArrayList<>();
            woOpReportWorkHoursList.add(woOpReportWorkHours);
            //此处修改是为了按照新的接口来
            cancelOnlineParameter.put("wo_op_report_data", woOpReportWorkHoursList);
            cancelOnlineRawData.put("parameter", cancelOnlineParameter);
            cancelOnlineRawData.putAll(commonRawDataMap);
            BottomButtonDigiwinAthena cancelOnlineButton = BottomButtonDigiwinAthena.createCancelOnlineButton(locale, cancelOnlineRawData);
            ModuleUtils.addRefreshPageId(cancelOnlineButton, apiRequest.getPageId());
            buttonList.add(cancelOnlineButton);
            //已上线需要显示:下线按钮
            Map<String, Object> offlineRawData = new HashMap<>();
            Map<String, Object> offlineParameter = new HashMap<>();
            List<Map<String, Object>> woOpReportInfoList = new ArrayList<>();
            Map<String, Object> woOpReportInfo = new HashMap<>();
            List<Map<String, Object>> woOpReportWorkHoursDetailList = new ArrayList<>();
            Map<String, Object> woOpReportWorkHoursDetail = new HashMap<>();
            woOpReportWorkHoursDetail.putAll(mainDataInfo);
            woOpReportWorkHoursDetail.putAll(businessUnit);
            woOpReportWorkHoursDetailList.add(woOpReportWorkHoursDetail);
            woOpReportInfo.putAll(woOpReportWorkHoursDetail);
            woOpReportInfo.put("isEnter", false);
            woOpReportInfo.put("isWorkHourOffline", true);
            woOpReportInfo.put("isWorkHourToAbnormalTask", false);
            //1.工单上线;2.人员下线回报;3.进度回报;4.人员上线回报;5.任务结束
            woOpReportInfo.put("process_category", "2");
            woOpReportInfo.put("wo_op_report_work_hours_detail", woOpReportWorkHoursDetailList);
            woOpReportInfoList.add(woOpReportInfo);
            offlineParameter.put("wo_op_report_info", woOpReportInfoList);
            offlineRawData.put("parameter", offlineParameter);
            offlineRawData.putAll(commonRawDataMap);

            Map<String, Object> submitRequestMap = new HashMap<>();
            Map<String, Object> submitRawData = new HashMap<>();
            Map<String, Object> submitWoOpReportData = new HashMap<>();
            submitWoOpReportData.put("wo_op_report_data", woOpReportInfoList);
            submitRawData.put("data", submitWoOpReportData);
            UiBotAction pcUiBotAction = null;
            if (!CollectionUtils.isEmpty(pcButtonActions)) {
                pcUiBotAction = pcButtonActions.stream().filter(
                                item -> "submit_workhour_offline".equalsIgnoreCase(item.getId()))
                        .findFirst().orElse(null);
            }
            submitRawData.put("action", pcUiBotAction);
            submitRequestMap.put("iamUserToken", apiRequest.getIamUserToken());
            submitRequestMap.put("locale", locale);
            submitRequestMap.put("clientId", apiRequest.getClientId());
            submitRequestMap.put("rawData", submitRawData);
            offlineRawData.put("submitRequest", submitRequestMap);

            //人员下线按钮
            BottomButtonDigiwinAthena offlineButton = BottomButtonDigiwinAthena.createOfflineButton(apiRequest.getPageId(), locale, offlineRawData);
            ModuleUtils.addRefreshPageId(offlineButton, apiRequest.getRefreshPageId());
            buttonList.add(offlineButton);

            uiBotLayouts.add(new UiBotLayout("bottomButton", BottomButtonDigiwinAthena.COMPONENT_TYPE));
            pageData.put("bottomButton", buttonList);
        }
        content.setPageData(pageData);
        content.setLayout(uiBotLayouts);
        customGroup.setContent(content);
        if (!CollectionUtils.isEmpty(leftTitle)) {
            customGroup.setName(leftTitle.get(0));
        }
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        return customGroup;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        SpringContextHolder.getBean(UiBotDesignerRenderService.class).buildCmptDsl(cmptContext, executeContext, this.getContentGroup(), data, mobilePageRawData);
    }
}
