package com.digiwin.mobile.mobileuibot.core.component.group;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author wuyang
 * @date 2022/5/26
 */
@Component
public class CustomGroupParamAnalyzer implements ComponentParamAnalyzer<CustomGroup, Map<String, Object>> {

    @Autowired
    private ComponentParamAnalyzerFactory componentParamAnalyzerFactory;

    @Override
    public String getComponentType() {
        return CustomGroup.COMPONENT_TYPE;
    }

    @Override
    public Class<CustomGroup> getSubmitParamType() {
        return CustomGroup.class;
    }

    @Override
    public Map<String, Object> analyzeSubmitParam(Object submitParam) {
        CustomGroup customGroup = (CustomGroup) submitParam;
        Map<String, Object> datas = new HashMap<>();
        for (ActionSubmitParam param : customGroup.getParams()) {
            String type = param.getType();
            // 跳过不处理
            if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                continue;
            }

            String schema = param.getSchema();
            Object paramObj = param.getParams();
            Object analyzedParam =
                    this.componentParamAnalyzerFactory.get(type).analyzeSubmitParam(paramObj);
//            if (InputSingleText.COMPONENT_TYPE.equalsIgnoreCase(type)
//                    || InputMultiText.COMPONENT_TYPE.equalsIgnoreCase(type)) {
//
//            } else {
//
//            }
            datas.put(schema, analyzedParam);
        }
        return datas;
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {
    }
}