package com.digiwin.mobile.mobileuibot.core.component.group;

import java.util.Objects;

/**
 * <p>功能描述：自定义分组组件样式枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomGroupStyleTypeEnum
 * @Author: Zaregoto
 * @Date: 2022/6/1 11:37
 */
public enum CustomGroupStyleTypeEnum {
    /**
     * 录入界面中的样式
     */
    STYLE_INPUT_FORM(1),

    /**
     * 左滑页面无边框样式
     */
    STYLE_LEFT_SLIP_UNBORDERED(2),
    /**
     * 使用地方为签核条目详情底部弹窗里的单头
     */
    STYLE_APPROVAL_ITEM_DETAIL(22),

    /**
     * 首页的样式（现在用在“为你推荐”区域）
     */
    STYLE_INDEX(3),

    /**
     * 左滑页面有边框样式
     */
    STYLE_LEFT_SLIP_BORDERED(4),

    /**
     * 包含标题的左滑边框样式
     */
    STYLE_LEFT_SLIP_INCLUDE_TITLE_BORDERED(5),

    /**
     * 标题在边框区域内的样式(不带边框)--左右间距24px
     */
    STYLE_ZTB_SCAN_RECEIVE(6),
    /**
     * 标题在边框区域内的样式(带边框)--左右间距24px
     */
    STYLE_ZTB_TITLE(61),
    /**
     * 首页我的任务样式
     */
    STYLE_INDEX_MY_TODO(7),
    /**
     * 代表左图右文
     */
    LEFT_IMAGE_RIGHT_TEXT(8),

    /**
     * 代表右图左文
     */
    RIGHT_IMAGE_LEFT_TEXT(9),

    /**
     * 上图下文
     */
    TOP_IMAGE_DOWN_TEXT(10),

    /**
     * 上文下图
     */
    DOWN_IMAGE_TOP_TEXT(11),

    /**
     * 纯图片
     */
    IMAGE_ONLY(12),

    /**
     * 纯内容
     */
    TEXT_ONLY(13),

    /**
     * 标题黑色样式
     */
    TITLE_BLACK(14),

    /**
     * 纯内容去掉下边距只有左右边距
     */
    TEXT_ONLY_NO_PADDING_BOTTOM(131),
    /**
     * 纯内容去掉所以外边距
     */
    TEXT_ONLY_NO_PADDING(132),

    /**
     * 标题组外显示，内容左右间距为0，标题颜色为#999999 无加粗
     */
    TEXT_OUTSIDE_THE_TITLE_GROUP(133),
    ;

    private final Integer value;

    CustomGroupStyleTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static CustomGroupStyleTypeEnum getEnumByValue(Integer value) {
        for (CustomGroupStyleTypeEnum testedEnum : CustomGroupStyleTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
