package com.digiwin.mobile.mobileuibot.core.component.h5link;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.Data;

import java.util.Map;

/**
 * <p>功能描述：H5链接组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: H5Link.java
 * @Author: wangjwc
 * @Date: created at 2025/9/29 17:42
 */
@Data
public class H5Link extends BaseMobileComponent {
    private static final long serialVersionUID = -2046818955695481670L;
    public static final String COMPONENT_TYPE = "CUSTOM_COMPONENT";

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    /**
     * 标题
     */
    private String title;
    /**
     * 部件类型来源，0：租户部件，1：ISV部件
     */
    private Integer labelTypeSource;

    /**
     * 组件内容属性值json
     */
    private Map<String, Object> contentConfig;
}
