package com.digiwin.mobile.mobileuibot.core.component.horizontalprogress;

import com.digiwin.mobile.mobileuibot.core.component.basic.Label;

import java.io.Serializable;

/**
 * 水平进度组件--关卡节点
 *
 * @author zhangjj
 * @date 2021/11/29 0029 17:44
 */
public class HorizontalProgressItem implements Serializable {
    private static final long serialVersionUID = 7880578367741150898L;
    /**
     * 关卡id
     */
    private String id;

    /**
     * 关卡名称
     */
    private String name;

    /**
     * 关卡类型
     */
    private Integer type;

    /**
     * 标签（展示在名称后面）
     */
    private Label label;

    /**
     * 是否可点击
     */
    private Boolean clickable;

    /**
     * 默认选中
     */
    private Boolean defaultSelected = false;

    /**
     * 下面详情
     */
    private HorizontalProgressItemDetail detail;

    public static class HorizontalProgressItemDetail {

        private String url;

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Label getLabel() {
        return label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Boolean getClickable() {
        return clickable;
    }

    public void setClickable(Boolean clickable) {
        this.clickable = clickable;
    }

    public Boolean getDefaultSelected() {
        return defaultSelected;
    }

    public void setDefaultSelected(Boolean defaultSelected) {
        this.defaultSelected = defaultSelected;
    }

    public HorizontalProgressItemDetail getDetail() {
        return detail;
    }

    public void setDetail(HorizontalProgressItemDetail detail) {
        this.detail = detail;
    }
}
