package com.digiwin.mobile.mobileuibot.core.component.image.swiper;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContent;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewSizeModeEnum;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailFixedNameEnum;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：轮播图组件数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Swiper
 * @Author: Zaregoto
 * @Date: 2021/10/20 17:04
 */
public class Swiper extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = 1937756210551887482L;
    public static final String COMPONENT_TYPE = "SWIPER";

    private List<BaseImageContent> content;
    private Integer sizeMode;
    /**
     * 标题的样式类型
     * 1-标题弱化，呈灰色， 2-标题正常，呈黑色， 3-标题黑色加粗，字号30px
     */
    private Integer titleStyleType;

    //轮播名称
    private String title;
    //轮播是否可缩放
    private Boolean zoomable;

    //高度
    private Integer height;

    //是否自动播放 0-否 1-是
    private Integer autoPlay;


    /**
     *  背景色
     */
    private String backgroundColor;

    /**
     *  边距，0：无边距 ；1：有边距
     */
    private Integer paddingFlag;

    @Override
    public String returnComponentType() {
        return Swiper.COMPONENT_TYPE;
    }

    public Swiper() {
    }

    public static Swiper create(String locale, String iamUserToken, Map<String, Object> detailInfo) {
        List<BaseImageContent> contentList = new ArrayList<>();

        Swiper swiper = new Swiper();
        if (contentList.size() > 0) {
            swiper.setContent(contentList);
            swiper.setSizeMode(WebviewSizeModeEnum.SMALL.getMode());
            swiper.setTitle(
                    LocaleUtil.getMobileTextByKey(locale, SearchItemDetailFixedNameEnum.QUESTION_PICTURE.getValue())
            );
            swiper.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_THREE.getValue());
            swiper.setZoomable(true);
        }

        return swiper;
    }

    @Override
    public void initSetting(String locale) {
        if (StringUtils.hasLength(title)) {
            this.setTitle(LocaleUtil.getMobileTextByDatabaseKey(locale, title));
        }
    }

    public List<BaseImageContent> getContent() {
        return content;
    }

    public void setContent(List<BaseImageContent> content) {
        this.content = content;
    }

    public Integer getSizeMode() {
        return sizeMode;
    }

    public void setSizeMode(Integer sizeMode) {
        this.sizeMode = sizeMode;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Boolean getZoomable() {
        return zoomable;
    }

    public void setZoomable(Boolean zoomable) {
        this.zoomable = zoomable;
    }

    public Integer getTitleStyleType() {
        return titleStyleType;
    }

    public void setTitleStyleType(Integer titleStyleType) {
        this.titleStyleType = titleStyleType;
    }

    public Integer getAutoPlay() {
        return autoPlay;
    }

    public void setAutoPlay(Integer autoPlay) {
        this.autoPlay = autoPlay;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getBackgroundColor() {
        return backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Integer getPaddingFlag() {
        return paddingFlag;
    }

    public void setPaddingFlag(Integer paddingFlag) {
        this.paddingFlag = paddingFlag;
    }
}
