package com.digiwin.mobile.mobileuibot.core.component.index;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import lombok.Data;
import org.springframework.util.StringUtils;

/**
 * 功能: 司机首页插画 组件
 *
 * @author: wjw
 * @date: created at 2023/3/9
 */
@Data
public class DriveTips extends BaseMobileComponent {
    private static final long serialVersionUID = -2654397009082649892L;
    public static final String COMPONENT_TYPE = "DRIVE_TIPS";

    private String title;
    private String subTitle;
    private Button button;

    @Override
    public String returnComponentType() {
        return DriveTips.COMPONENT_TYPE;
    }

    public void initSetting(LocaleService localeService, String locale) {
        if (StringUtils.hasLength(this.title)) {
            this.title = localeService.getLanguageValue(locale, this.title);
        }
        if (StringUtils.hasLength(this.subTitle)) {
            this.subTitle = localeService.getLanguageValue(locale, this.subTitle);
        }
        if (this.button != null) {
            if (StringUtils.hasLength(this.button.getName())) {
                this.button.setName(localeService.getLanguageValue(locale, this.button.getName()));
            }
            if (StringUtils.hasLength(this.button.getSubName())) {
                this.button.setSubName(localeService.getLanguageValue(locale, this.button.getSubName()));
            }
            Action action = this.button.getAction();
            if (action != null) {
                action.setJumpPageTitle(localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                if (StringUtils.hasLength(action.getRequestUrl())) {
                    action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
                }
            }
        }
    }
}
