package com.digiwin.mobile.mobileuibot.core.component.index;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.model.EocSetInfo;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.UserIntegrity;
import lombok.Data;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 功能: 非超级管理员 首页插画 组件
 *
 * @author: wjw
 * @date: created at 2023/3/9
 */
@Data
public class NonSuperAdminTips extends BaseMobileComponent {
    private static final long serialVersionUID = -2654397009082649892L;
    public static final String COMPONENT_TYPE = "NONSUPERADMIN_TIPS";

    private String title;
    private List<String> subTitle;
    // 提示场景
    private Map<String, List<String>> tips;

    @Override
    public String returnComponentType() {
        return NonSuperAdminTips.COMPONENT_TYPE;
    }

    public void initSetting(LocaleService localeService, String locale, ApiRawData rawData) {
        if (StringUtils.hasLength(this.title)) {
            this.title = localeService.getLanguageValue(locale, this.title);
        }
        if (!CollectionUtils.isEmpty(tips)) {
            Boolean superAdmin = rawData.getBoolean("superAdmin");
            EocSetInfo eocSetInfo = rawData.getObject("eocSetInfo", EocSetInfo.class);
            UserIntegrity userIntegrity = rawData.getObject("userIntegrity", UserIntegrity.class);
            if (superAdmin) {
                // 超级管理员弹窗
                this.subTitle = tips.get("tip4");
            } else {
                if (eocSetInfo.getRemindUnitSetting() && !userIntegrity.getUserIntegrity()) {
                    // 运营单元未设定，且用户设定不完整，需要弹窗
                    this.subTitle = tips.get("tip1");
                } else if (eocSetInfo.getRemindUnitSetting() && userIntegrity.getUserIntegrity()) {
                    // 运营单元未设定，用户设定完整，需要弹窗
                    this.subTitle = tips.get("tip2");
                } else if (!eocSetInfo.getRemindUnitSetting() && !userIntegrity.getUserIntegrity()) {
                    // 运营单元已设定，用户设定不完整，需要弹窗
                    this.subTitle = tips.get("tip3");
                } else {
                    this.subTitle = tips.get("tip1");
                }
            }
        }
        if (!CollectionUtils.isEmpty(subTitle)) {
            this.subTitle = this.subTitle.stream().map(s -> localeService.getLanguageValue(locale, s)).collect(Collectors.toList());
        }
    }
}
