package com.digiwin.mobile.mobileuibot.core.component.index;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListCommonFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListFilterSwitch;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListGroupFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListSeniorFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListSort;
import com.digiwin.mobile.mobileuibot.model.db1.PersonalConfiguration;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCalendar;
import com.digiwin.mobile.mobileuibot.task.model.TaskSummary;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>功能描述：首页-我的任务 组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TodoList
 * @Author: wangjwc
 * @Date: 2023/6/5 12:06
 */
@Data
@Accessors(chain = true)
public class TodoList extends BaseMobileComponent {
    private static final long serialVersionUID = 557119517870332437L;
    public static final String COMPONENT_TYPE = "TODO_LIST";

    private Boolean enableMqtt;
    private Boolean isTeamTask;
    private Integer calenderType;
    private PersonalConfiguration personalConfiguration;
    private Button addTask;

    private DigiwinAtmcCalendar teamMember;
    private List<TaskSummary> todoList;
    private String searchUrl;
    private List<String> searchIdList;
    private String queryParam;
    private List<String> filterIdList;
    private List<CardListFilter> filterList;

    private CardListSeniorFilter seniorFilter;

    private CardListCommonFilter commonFilter;

    private List<String> groupFilterIdList;
    private List<CardListGroupFilter> groupFilterList;

    private CardListSort sortFilter;

    private CardListFilterSwitch showEocSwitch;

    private CardListFilterSwitch showHandledCardSwitch;

    private Boolean isUseSeniorFilter;

    @Override
    public String returnComponentType() {
        return TodoList.COMPONENT_TYPE;
    }

    public void putAll(TodoList todoList) {
        if (null != todoList.getEnableMqtt()) {
            this.enableMqtt = todoList.getEnableMqtt();
        }
        if (null != todoList.getIsTeamTask()) {
            this.isTeamTask = todoList.getIsTeamTask();
        }
        if (null != todoList.getCalenderType()) {
            this.calenderType = todoList.getCalenderType();
        }
        if (null != todoList.getPersonalConfiguration()) {
            this.personalConfiguration = todoList.getPersonalConfiguration();
        }
        if (null != todoList.getAddTask()) {
            this.addTask = todoList.getAddTask();
        }
        if (null != todoList.getTeamMember()) {
            this.teamMember = todoList.getTeamMember();
        }
        if (null != todoList.getTodoList()) {
            this.todoList = todoList.getTodoList();
        }
        if (null != todoList.getSearchUrl()) {
            this.searchUrl = todoList.getSearchUrl();
        }
        if (null != todoList.getSearchIdList()) {
            this.searchIdList = todoList.getSearchIdList();
        }
        if (null != todoList.getQueryParam()) {
            this.queryParam = todoList.getQueryParam();
        }
        if (null != todoList.getFilterIdList()) {
            this.filterIdList = todoList.getFilterIdList();
        }
        if (null != todoList.getFilterList()) {
            this.filterList = todoList.getFilterList();
        }
        if (null != todoList.getCommonFilter()) {
            this.commonFilter = todoList.getCommonFilter();
        }
        if (null != todoList.getSeniorFilter()) {
            this.seniorFilter = todoList.getSeniorFilter();
        }
        if (null != todoList.getGroupFilterIdList()) {
            this.groupFilterIdList = todoList.getGroupFilterIdList();
        }
        if (null != todoList.getGroupFilterList()) {
            this.groupFilterList = todoList.getGroupFilterList();
        }
        if (null != todoList.getSortFilter()) {
            this.sortFilter = todoList.getSortFilter();
        }
        if (null != todoList.getShowEocSwitch()) {
            this.showEocSwitch = todoList.getShowEocSwitch();
        }
        if (null != todoList.getShowHandledCardSwitch()) {
            this.showHandledCardSwitch = todoList.getShowHandledCardSwitch();
        }
        if (null != todoList.getIsUseSeniorFilter()) {
            this.isUseSeniorFilter = todoList.getIsUseSeniorFilter();
        }
    }
}
