package com.digiwin.mobile.mobileuibot.core.component.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListOption;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemAsyncConfig;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.LabelSystemData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 首页-三方待办组件
 */
@Data
@Accessors(chain = true)
public class TripartiteTodoList<T> extends BaseMobileComponent {

    public static final String COMPONENT_TYPE = "TRIPARTITE_TODO_LIST";
    private static final long serialVersionUID = 6021743651601514471L;

    private String nodeName;

    private String nodeId;

    /**
     * 是否使用展开收起功能
     */
    private Boolean isExpand = false;

    private List<T> data = new ArrayList<>();

    private CustomTabControllerItemAsyncConfig asyncConfig;

    /**
     * 筛选功能--筛选项
     */
    private List<CardListFilter> filterList;

    /**
     * 附加参数
     */
    private Map<String, Object> rawData;

    @Override
    public String returnComponentType() {
        return TripartiteTodoList.COMPONENT_TYPE;
    }

    public static Map<String, Object> createTripartiteToDoList(ApiRequest apiRequest, UiBotPageData pageData
            , List<LabelSystemData> labelSystemDataList, String schema) {
        Map<String, Object> mapData = new HashMap<>();

        List<TripartiteTodoList> todoLists = new ArrayList<>();
        List<CardListFilter> filterList = new ArrayList<>();
        CardListFilter filter = new CardListFilter();
        filter.setFilterId("type");
        filter.setFilterName("");

        List<CardListOption> filterOptionList = new ArrayList<>();

        Map<String, Object> map = (Map<String, Object>) pageData.get(schema);
        Map<String, Object> configMap = (Map<String, Object>) map.get("asyncConfig");
        String requestId = String.valueOf(configMap.get("requestId"));
        String requestUrl = String.valueOf(configMap.get("requestUrl"));

        CustomTabControllerItemAsyncConfig itemAsyncConfig = new CustomTabControllerItemAsyncConfig();
        itemAsyncConfig.setIamUserToken(apiRequest.getIamUserToken());
        itemAsyncConfig.setLocale(apiRequest.getLocale());
        itemAsyncConfig.setClientId(apiRequest.getClientId());
        itemAsyncConfig.setTenantId(apiRequest.getTenantId());
        itemAsyncConfig.setRequestId(requestId);
        String newUrl = AppContext.getBaseUrl() + requestUrl
                + "?clientId=" + apiRequest.getClientId()
                + "&tenantId=" + apiRequest.getTenantId();
        itemAsyncConfig.setRequestUrl(newUrl);
        filterList.add(filter);
        mapData.put("data", todoLists);
        mapData.put("filterList", filterList);
        if (CollectionUtils.isEmpty(labelSystemDataList)) {
            return mapData;
        }
        labelSystemDataList.forEach(labelSystemData -> {
            TripartiteTodoList todoList = new TripartiteTodoList();
            todoList.setNodeName(labelSystemData.getAppName());
            todoList.setNodeId(String.valueOf(labelSystemData.getId()));
            todoList.setIsExpand(true);
            todoList.setAsyncConfig(itemAsyncConfig);
            Map<String, Object> rowData = new HashMap<>();
            rowData.put("id", labelSystemData.getId());
            rowData.put("appCode", labelSystemData.getAppId());
            rowData.put("appName", labelSystemData.getAppName());
            rowData.put("callBackUrl", labelSystemData.getCallBackUrl());
            rowData.put("protocolType", labelSystemData.getProtocolType());
            rowData.put("isNeedSsoUrl", labelSystemData.getIsNeedSsoUrl());
            rowData.put("isFixedRefresh", labelSystemData.getIsFixedRefresh());
            todoList.setRawData(rowData);
            todoLists.add(todoList);

            CardListOption filterOption = new CardListOption();
            filterOption.setFilterOptionId(String.valueOf(labelSystemData.getId()));
            filterOption.setFilterOptionName(labelSystemData.getAppName());
            filterOption.setIsSelect(false);
            filterOptionList.add(filterOption);
            filter.setFilterOptionList(filterOptionList);
        });
        return mapData;
    }

}