package com.digiwin.mobile.mobileuibot.core.component.input.actionsheet;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputActionSheet
 * @Author: Zaregoto
 * @Date: 2021/8/15 15:07
 */
public class InputActionSheet extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = 3739649983483713559L;
    public static final String COMPONENT_TYPE = "INPUT_ACTION_SHEET";

    @Override public String returnComponentType() {
        return InputActionSheet.COMPONENT_TYPE;
    }

    private String title;
    private List<Option> options;
    private String type;
    private String selectId;

    public InputActionSheet() {
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Option> getOptions() {
        return options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSelectId() {
        return selectId;
    }

    public void setSelectId(String selectId) {
        this.selectId = selectId;
    }

    public static class Option implements Serializable {
        private String id;
        private String name;
        private Boolean disabled = false;
        /**
         * 当前选项选择后展示的下一步界面的操作。目前只支持开窗单选
         */
        private List<InputWindowSingleSelect> nextOperations;

        public Option() {
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Boolean getDisabled() {
            return disabled;
        }

        public void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        public List<InputWindowSingleSelect> getNextOperations() {
            return nextOperations;
        }

        public void setNextOperations(List<InputWindowSingleSelect> nextOperations) {
            this.nextOperations = nextOperations;
        }
    }
}
