package com.digiwin.mobile.mobileuibot.core.component.input.actionsheet;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputActionSheetParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/8/15 15:13
 */
@Component("inputActionSheetParamAnalyzer")
public class InputActionSheetParamAnalyzer implements ComponentParamAnalyzer<InputActionSheet, String> {

    private static final Logger logger = LoggerFactory.getLogger(InputActionSheetParamAnalyzer.class);

    @Override public String getComponentType() {
        return InputActionSheet.COMPONENT_TYPE;
    }

    @Override public Class<InputActionSheet> getSubmitParamType() {
        return InputActionSheet.class;
    }

    @Override public String analyzeSubmitParam(Object submitParam) {
        InputActionSheet inputActionSheet = (InputActionSheet) submitParam;
        return Optional.ofNullable(inputActionSheet).map(InputActionSheet::getSelectId).orElse("");
    }

    @Override public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
        UiBotPageData pageData, Object... args) {

    }
}
