package com.digiwin.mobile.mobileuibot.core.component.input.addersubstracter;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Objects;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AdderSubstracter
 * @Author: wuyang
 * @Date: 20230227
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AdderSubstracter extends BaseInputMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "ADDER_SUBSTRACTER";
    private static final long serialVersionUID = 5243367271181883447L;

    private String title;
    /**
     * 步长
     */
    private Double stepValue =  new Double(1);

    /**
     * 最大值
     */
    private Double maxNumber = new Double(100);
    /**
     * 当达到最大数量时的提示语，由开发平台内置
     */
    private String maxHint;
    /**
     * 最小值
     */
    private Double minNumber = new Double(0);
    /**
     * 当达到最小数量时的提示语，由开发平台内置
     */
    private String minHint;
    /**
     * 装置中间默认值
     */
    private Double defaultNumber;
    /**
     * 是否支持手动输入，默认true
     */
    private Boolean useManualInput = true;
    /**
     * 是否包含0
     */
    private Boolean containsZero = false;

    public static AdderSubstracter create(String locale, LocaleService localeService, String maxNumber,
                                          String unReceiptQty, Double minNumber, Boolean containsZero,
                                          Boolean showHint) {
        AdderSubstracter adderSubstacter = new AdderSubstracter();
        if (!StringUtils.hasLength(maxNumber)) {
            maxNumber = unReceiptQty;
        }
        adderSubstacter.setMaxNumber(StringUtils.hasLength(maxNumber) ? Double.parseDouble(maxNumber) : 0.0);
        adderSubstacter.setMinNumber(minNumber);
        if (showHint) {
            adderSubstacter.setMaxHint(localeService.getLanguageValue(locale, "已全部出库"));
            adderSubstacter.setMinHint(localeService.getLanguageValue(locale, "已达到最小数量"));
        }
        adderSubstacter.setDefaultNumber(StringUtils.hasLength(unReceiptQty) ? Double.parseDouble(unReceiptQty) : 0.0);
        adderSubstacter.setContainsZero(containsZero);
        return adderSubstacter;
    }

    @Override
    public String returnComponentType() {
        return AdderSubstracter.COMPONENT_TYPE;
    }

    private Double returnDefaultValue(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return new Double(value.toString());
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.defaultNumber = this.returnDefaultValue(UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema));
        if (Objects.isNull(defaultNumber)) {
            this.defaultNumber = (this.maxNumber + this.minNumber) / 2;
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        AdderSubstracter adderSubstracter = new AdderSubstracter();
        adderSubstracter.setComponentId(rawContent.getComponentId());
        adderSubstracter.setTitle(rawContent.getLabel());
        adderSubstracter.setEnable(rawContent.getEditable());
        //将配置中的setting转化成成对象
        Card.DesignerRawCard.Content.AdderSubstracterObj adderSubstracterObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.AdderSubstracterObj.class);
        if (adderSubstracterObj != null) {
            adderSubstracter.setMinHint(adderSubstracterObj.getMinHint());
            adderSubstracter.setMaxHint(adderSubstracterObj.getMaxHint());
            adderSubstracter.setMaxNumber(adderSubstracterObj.getMaxNumber());
            adderSubstracter.setMinNumber(adderSubstracterObj.getMinNumber());
            adderSubstracter.setStepValue(adderSubstracterObj.getStepValue());
            adderSubstracter.setUseManualInput(adderSubstracterObj.getUseManualInput());
            adderSubstracter.setContainsZero(adderSubstracterObj.getContainsZero());
        }
        adderSubstracter.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return adderSubstracter;
    }


}
