package com.digiwin.mobile.mobileuibot.core.component.input.addersubstracter;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class AdderSubstracterParamAnalyzer implements ComponentParamAnalyzer<AdderSubstracter, Number> {

    @Override
    public String getComponentType() {
        return AdderSubstracter.COMPONENT_TYPE;
    }

    @Override
    public Class<AdderSubstracter> getSubmitParamType() {
        return AdderSubstracter.class;
    }

    @Override
    public Number analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof AdderSubstracter)) {
            log.debug("submitParam is not instanceof ProgressBar component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return null;
        }
        return ((AdderSubstracter) submitParam).getDefaultNumber();
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {
    }

}
