package com.digiwin.mobile.mobileuibot.core.component.input.attachment;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgressWorkItemAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachmentData;

import java.io.Serializable;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AttachmentFile
 * @Author: Zaregoto
 * @Date: 2021/6/14 15:59
 */
public class AttachmentFile implements Serializable {
    private static final long serialVersionUID = -5456060585608658736L;

    //文件状态可选值
    public static final String FILE_STATUS_DELETE = "DELETE";
    public static final String FILE_STATUS_NEW = "NEW";

    /**
     * 附件文件类型，英文小写，不带点。如：pdf,docx
     */
    private String fileExtension;
    private String fileId;
    private String fileName;
    /**
     * 附件大小。单位：字节
     */
    private Long fileSize;

    /**
     * 只用在视频封面
     */
    private String coverId;

    /**
     * 附件分享链接
     */
    private String shareUrl;
    /**
     * 上传时间。格式：YYYY-MM-DD HH:MM:SS
     */
    private String uploadTime;
    /**
     * 上传人姓名
     */
    private String uploader;

    /**
     * 文件状态
     * 可选值：NEW：新增；DELETE：删除（此值提交时才需要，新增的附件为NEW，删除的附件为DELETE，原本有且提交时没删除的为空）
     */
    private String status;

    /**
     * 是否可查看 TRUE：可以查看，FALSE：不可查看
     */
    private Boolean viewable;

    /**
     * 预览地址
     */
    private String previewUrl;

    private String base64Data;

    //base64Id,因为地端数据太大只传id
    private String base64DataId;

    //视频封面的base64
    private String coverBase64Data;

    public AttachmentFile() {
    }

    private AttachmentFile(String fileExtension, String fileId, String fileName, Long fileSize,
                           String shareUrl, String uploadTime, String uploader) {
        this.fileExtension = fileExtension;
        this.fileId = fileId;
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.shareUrl = shareUrl;
        this.uploadTime = uploadTime;
        this.uploader = uploader;
    }

    public static AttachmentFile create(String locale, UiBotAttachmentData uiBotAttachmentData) {
        AttachmentFile attachmentFile = new AttachmentFile();
        attachmentFile.setFileExtension(AttachmentUtil.getAttachmentFileSuffix(uiBotAttachmentData.getName()));
        attachmentFile.setFileId(uiBotAttachmentData.getId());
        attachmentFile.setFileName(uiBotAttachmentData.getName());
        if (uiBotAttachmentData.getSize() == null) {
            attachmentFile.setFileSize(99999L);
        } else {
            attachmentFile.setFileSize(uiBotAttachmentData.getSize().longValue());
        }
        attachmentFile.setShareUrl("");
        attachmentFile.setUploadTime(uiBotAttachmentData.getCreateDate());
        attachmentFile.setUploader(uiBotAttachmentData.getUploadUserName());
        attachmentFile.setBase64Data(uiBotAttachmentData.getBase64Data());
        attachmentFile.setCoverBase64Data(uiBotAttachmentData.getCoverBase64Data());
        attachmentFile.setFileExtension(uiBotAttachmentData.getFileExtension());
        attachmentFile.setBase64DataId(uiBotAttachmentData.getBase64DataId());
        return attachmentFile;
    }

    public static AttachmentFile create(String locale, DigiwinAtmcTaskProgressWorkItemAttachment digiwinAtmcTaskProgressWorkItemAttachment) {
        AttachmentFile attachmentFile = new AttachmentFile();
        attachmentFile.setFileExtension(AttachmentUtil.getAttachmentFileSuffix(digiwinAtmcTaskProgressWorkItemAttachment.getName()));
        attachmentFile.setFileId(digiwinAtmcTaskProgressWorkItemAttachment.getId());
        attachmentFile.setFileName(digiwinAtmcTaskProgressWorkItemAttachment.getName());
        if (digiwinAtmcTaskProgressWorkItemAttachment.getSize() == null) {
            attachmentFile.setFileSize(99999L);
        } else {
            attachmentFile.setFileSize(digiwinAtmcTaskProgressWorkItemAttachment.getSize().longValue());
        }
        attachmentFile.setShareUrl("");
        attachmentFile.setUploadTime(digiwinAtmcTaskProgressWorkItemAttachment.getCreateDate());
        attachmentFile.setUploader(digiwinAtmcTaskProgressWorkItemAttachment.getUploadUserName());

        return attachmentFile;
    }

    public static AttachmentFile create(String fileExtension, String fileId, String fileName, Long fileSize,
                                        String shareUrl, String uploadTime, String uploader) {
        AttachmentFile attachmentFile = new AttachmentFile();
        attachmentFile.setFileExtension(fileExtension);
        attachmentFile.setFileId(fileId);
        attachmentFile.setFileName(fileName);
        attachmentFile.setShareUrl(shareUrl);
        attachmentFile.setUploadTime(uploadTime);
        attachmentFile.setUploader(uploader);
        attachmentFile.setFileSize(fileSize);

        return attachmentFile;
    }

    public String getFileExtension() {
        return fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getShareUrl() {
        return shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public String getUploadTime() {
        return uploadTime;
    }

    public void setUploadTime(String uploadTime) {
        this.uploadTime = uploadTime;
    }

    public String getUploader() {
        return uploader;
    }

    public void setUploader(String uploader) {
        this.uploader = uploader;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getViewable() {
        return viewable;
    }

    public void setViewable(Boolean viewable) {
        this.viewable = viewable;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getCoverId() {
        return coverId;
    }

    public void setCoverId(String coverId) {
        this.coverId = coverId;
    }

    public String getBase64Data() {
        return base64Data;
    }

    public void setBase64Data(String base64Data) {
        this.base64Data = base64Data;
    }

    public String getCoverBase64Data() {
        return coverBase64Data;
    }

    public void setCoverBase64Data(String coverBase64Data) {
        this.coverBase64Data = coverBase64Data;
    }

    public String getBase64DataId() {
        return base64DataId;
    }

    public void setBase64DataId(String base64DataId) {
        this.base64DataId = base64DataId;
    }
}
