package com.digiwin.mobile.mobileuibot.core.component.input.attachment;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.approval.ApprovalActionNameEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Optional;

/**
 * <p>功能描述：附件组件参数解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AttachmentParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/6/22 23:37
 */
@Component("attachmentParamAnalyzer")
public class AttachmentParamAnalyzer implements ComponentParamAnalyzer<Attachment, UiBotAttachment> {

    private static final Logger logger = LoggerFactory.getLogger(AttachmentParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return Attachment.COMPONENT_TYPE;
    }

    @Override
    public Class<Attachment> getSubmitParamType() {
        return Attachment.class;
    }

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Override
    public UiBotAttachment analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof Attachment)) {
            logger.debug("submitParam is not instanceof Attachment component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return UiBotAttachment.createEmpty();
        }
        Attachment attachment = (Attachment) submitParam;
        UiBotAttachment uiBotAttachment = attachment.parseToUiBotAttachment(attachment, digiwinDmcProxyService);
        uiBotAttachment.filterNotDelete();
        return uiBotAttachment;
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {
        JSONObject action = apiRequest.getRawData().getJSONObject("action");
        if (null == action) {
            return;
        }
        PcUiBotSubmitAction submitAction = JsonUtil.objectToJavaObject(action, PcUiBotSubmitAction.class);
        PcUiBotSubmitExecuteContext executeContext = submitAction.getExecuteContext();
        if (null != executeContext) {
            // true  显示附件; false/null 不显示附件
            Boolean isTaskEngine = executeContext.getIsTaskEngine();
            if (BooleanUtils.isNotTrue(isTaskEngine)) {
                pageData.put(pageDataKey, null);
            }
        }
        if (!CollectionUtils.isEmpty(submitAction.getAttachActions())) {
            PcUiBotSubmitAction attachActions = submitAction.getAttachActions().get(0);
            String serviceId = Optional.ofNullable(attachActions.getServiceId()).map(PcUiBotActionServiceId::getName).orElse("");
            // pc前端控制逻辑 显示附件
            boolean flag = isShowAttachment(attachActions.getCategory(), serviceId);
            if (!flag) {
                pageData.put(pageDataKey, null);
            }
        } else {
            String serviceId = Optional.ofNullable(submitAction.getServiceId()).map(PcUiBotActionServiceId::getName).orElse("");
            boolean flag = isShowAttachment(submitAction.getCategory(), serviceId);
            if (!flag) {
                pageData.put(pageDataKey, null);
            }
        }
    }

    private boolean isShowAttachment(String category, String serviceId) {
        return (PcUiBotConstants.ACTION_CATEGORY_BPM_TASK_ENGINE.equals(category)
                && Lists.newArrayList("reexecute", "disagree", "agree").contains(serviceId))
                || (PcUiBotConstants.ACTION_CATEGORY_WORKFLOW.equals(category)
                && Lists.newArrayList(ApprovalActionNameEnum.WORKFLOW_ACT_RETURN.getValue()).contains(serviceId));
    }
}