package com.digiwin.mobile.mobileuibot.core.component.input.attachment;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：与鼎捷Athena集成时使用的附件原始数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AttachmentRawDataDigiwinAthena
 * @Author: Zaregoto
 * @Date: 2021/6/14 15:57
 */
public class AttachmentRawDataDigiwinAthena implements AttachmentRawData, Serializable {
    private static final long serialVersionUID = 7408850944648831395L;

    private String path;
    private String rowDataKey;

    @JsonProperty("row_data")
    @JSONField(name = "row_data")
    private Object rowData;

    private String tmActivityId;
    private String tmTaskId;

    /**
     * 上传类型
     * 上传到的DMC中间件的目录名
     */
    private String uploadCategory;
    private String uploadCategoryId;
    /**
     * 是否使用aam，true表示不使用，false或为空表示使用
     * 是否同步上传到aam（athena attachment management，雅典娜附件管理中心）
     */
    private Boolean disableAam;

    private String buckets;

    /**
     * 附件查看类型
     *
     * @see com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.AttachmentViewTypeEnum
     */
    private String type;
    /**
     * type =OUTER 时 有值
     */
    private String url;

    private Map<String, Object> extendParam;

    public AttachmentRawDataDigiwinAthena() {
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRowDataKey() {
        return rowDataKey;
    }

    public void setRowDataKey(String rowDataKey) {
        this.rowDataKey = rowDataKey;
    }

    public Object getRowData() {
        return rowData;
    }

    public void setRowData(Object rowData) {
        this.rowData = rowData;
    }

    public String getTmActivityId() {
        return tmActivityId;
    }

    public void setTmActivityId(String tmActivityId) {
        this.tmActivityId = tmActivityId;
    }

    public String getTmTaskId() {
        return tmTaskId;
    }

    public void setTmTaskId(String tmTaskId) {
        this.tmTaskId = tmTaskId;
    }

    public String getUploadCategory() {
        return uploadCategory;
    }

    public void setUploadCategory(String uploadCategory) {
        this.uploadCategory = uploadCategory;
    }

    public String getUploadCategoryId() {
        return uploadCategoryId;
    }

    public void setUploadCategoryId(String uploadCategoryId) {
        this.uploadCategoryId = uploadCategoryId;
    }

    public Boolean getDisableAam() {
        return disableAam;
    }

    public void setDisableAam(Boolean disableAam) {
        this.disableAam = disableAam;
    }

    public String getBuckets() {
        return buckets;
    }

    public void setBuckets(String buckets) {
        this.buckets = buckets;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, Object> getExtendParam() {
        return extendParam;
    }

    public void setExtendParam(Map<String, Object> extendParam) {
        this.extendParam = extendParam;
    }
}
