package com.digiwin.mobile.mobileuibot.core.component.input.attachment;

import org.springframework.util.StringUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * <p>功能描述：附件工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AttachmentUtil
 * @Author: Zaregoto
 * @Date: 2021/6/15 20:47
 */
public final class AttachmentUtil {

    public static String getAttachmentFileSuffix(String attachmentFilenName) {
        if (!StringUtils.hasLength(attachmentFilenName)) {
            return "";
        }
        String regExp = "^(.*)\\.(.*)|.*\\\\(.*)$";
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(attachmentFilenName);
        if (matcher.find()) {
            return matcher.group(matcher.groupCount() - 1);
        }
        return "";
    }

    public static void main(String[] args) {
        String fileName = "Screenshot_20220538_144720_com.digiwin.enterprise.athena.atn.jpg";
        System.out.println(AttachmentUtil.getAttachmentFileSuffix(fileName));
    }

}
