package com.digiwin.mobile.mobileuibot.core.component.input.attachment;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>功能描述：附件组件的大小限制</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: FileMaxSize
 * @Author: xujinc
 * @Date: 2023/09/01 15:51
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class FileMaxSize implements Serializable {
    private static final long serialVersionUID = -7260016907342158661L;

    private Long imageMaxSize;

    private Long videoMaxSize;

    private Long audioMaxSize;

    private Long otherMaxSize;

    public FileMaxSize(Long otherMaxSize) {
        this.otherMaxSize = otherMaxSize;
    }

    public FileMaxSize(Long imageMaxSize, Long videoMaxSize) {
        this.imageMaxSize = imageMaxSize;
        this.videoMaxSize = videoMaxSize;
    }

    public FileMaxSize(Long imageMaxSize, Long videoMaxSize, Long audioMaxSize) {
        this.imageMaxSize = imageMaxSize;
        this.videoMaxSize = videoMaxSize;
        this.audioMaxSize = audioMaxSize;
    }

    /**
     * 设计器存储的单位是MB(兆)，运行态使用的是B(byte)，故需要转换
     */
    public void MB2B() {
        if (this.imageMaxSize != null) {
            this.imageMaxSize = this.imageMaxSize * 1024 * 1024;
        }

        if (this.videoMaxSize != null) {
            this.videoMaxSize = this.videoMaxSize * 1024 * 1024;
        }

        if (this.audioMaxSize != null) {
            this.audioMaxSize = this.audioMaxSize * 1024 * 1024;
        }

        if (this.otherMaxSize != null) {
            this.otherMaxSize = this.otherMaxSize * 1024 * 1024;
        }
    }
}
