package com.digiwin.mobile.mobileuibot.core.component.input.calendar;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * <p>功能描述：日历组件日期对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputCalendarDate
 * @Author: Zaregoto
 * @Date: 2021/6/15 17:03
 */
public class InputCalendarDate implements Serializable {
    private static final long serialVersionUID = -1606135539786796354L;

    private String year;
    private String month;
    private String date;

    public InputCalendarDate() {
    }

    public static InputCalendarDate create(String year, String month, String date) {
        // TODO 增加防呆的逻辑
        InputCalendarDate inputCalendarDate = new InputCalendarDate();
        inputCalendarDate.setYear(year);
        inputCalendarDate.setMonth(month);
        inputCalendarDate.setDate(date);

        return inputCalendarDate;
    }

    public static InputCalendarDate create(int year, int month, int date) {
        // TODO 增加防呆的逻辑
        InputCalendarDate inputCalendarDate = new InputCalendarDate();
        inputCalendarDate.setYear(String.valueOf(year));
        inputCalendarDate.setMonth(String.valueOf(month));
        inputCalendarDate.setDate(String.valueOf(date));

        return inputCalendarDate;
    }

    /**
     * 当天
     *
     * @return
     */
    public static InputCalendarDate createToday() {
        LocalDate now = LocalDate.now();
        InputCalendarDate inputCalendarDate = new InputCalendarDate();
        inputCalendarDate.setYear(now.getYear() + "");
        inputCalendarDate.setMonth(now.getMonthValue() + "");
        inputCalendarDate.setDate(now.getDayOfMonth() + "");
        return inputCalendarDate;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }
}
