package com.digiwin.mobile.mobileuibot.core.component.input.calendar;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputCalendarParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/6/20 17:24
 */
@Component("inputCalendarParamAnalyzer")
public class InputCalendarParamAnalyzer implements ComponentParamAnalyzer<InputCalendar, String> {

    private static final Logger logger = LoggerFactory.getLogger(InputCalendarParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputCalendar.COMPONENT_TYPE;
    }

    @Override
    public Class<InputCalendar> getSubmitParamType() {
        return InputCalendar.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputCalendar)) {
            logger.debug("submitParam is not instanceof InputCalendar component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        InputCalendar inputCalendar = (InputCalendar) submitParam;
        // FIXME 6月迭代中日历控件提交参数先以兼容之前迭代的格式为主，故不解析此参数，改用text。后续需要与端上沟通依据不同组件传入对应的Model
//        if (inputCalendar.getDateValueList().isEmpty()) {
//            return "";
//        }
        if (null == inputCalendar.getInputText() || inputCalendar.getInputText().isEmpty()) {
            return "";
        }
        // wjw FIXME: 2023/5/30 S5 前端日期控件返回的日期2023.5.2，没有按照结构传入参数，故短解
        this.paddingDateForm(inputCalendar);
        return DateTimeUtil.getInputCalendarDateUseDefaultPattern(inputCalendar.getInputText());
    }

    private void paddingDateForm(InputCalendar inputCalendar) {
        String inputText = inputCalendar.getInputText();
        if (!StringUtils.hasLength(inputText)) {
            return;
        }
        String[] dates = inputText.trim().split(" ");
        String[] split = dates[0].split("\\.");
        if (split[1].length() == 1) {
            split[1] = "0" + split[1];
        }
        if (split[2].length() == 1) {
            split[2] = "0" + split[2];
        }
        String date = org.apache.commons.lang3.StringUtils.join(split, ".");
        if (dates.length > 1) {
            date = date + " " + dates[1];
        }
        inputCalendar.setInputText(date);
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {

    }
}
