package com.digiwin.mobile.mobileuibot.core.component.input.cascade;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.impl.DigiwinEocProxyServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wuyang
 * @desc 级联组件
 */
@Data
public class InputCascade extends BaseInputMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "INPUT_CASCADE";
    private static final long serialVersionUID = 1992386934614732678L;

    /**
     * 当前栏位的名称
     */
    private String title;
    /**
     * 级联的层级数
     */
    private Integer levelNums;
    /**
     * 级联显示样式
     */
    private Integer style;
    /**
     * 级联的数据类型 1：直接解析json  2：读取自接口
     */
    private Integer type;
    /**
     * 级联的下一层数据
     */
    private List<InputCascadeData> dataList;

    /**
     * 默认选中的项
     */
    private DefaultSelect defaultSelect;

    /**
     * 是否走提交
     */
    private Boolean isSubmit = false;
    /**
     * 提交的action
     */
    private Action submitAction;

    /**
     * V2版提交的值
     */
    private List<InputCascadeData> data;


    public InputCascade() {
    }

    public static InputCascade create(List<Map<String, Object>> companys, List<Map<String, Object>>
            factorys, String firstSchema, String secondSchema, String title, int levelNums,
                                      int type, int style, String locale) {
        InputCascade inputCascade = new InputCascade();
        inputCascade.setTitle(title);
        inputCascade.setType(type);
        inputCascade.setStyle(style);
        inputCascade.setRequired(true);
        inputCascade.setEnable(true);
        if (companys != null && !companys.isEmpty()) {
            List<InputCascadeData> dataList = new ArrayList<>(companys.size());
            for (Map<String, Object> company : companys) {
                InputCascadeData cascadeData = new InputCascadeData();
                String id = (String) company.get("id");
                cascadeData.setSchema(firstSchema);
                cascadeData.setId(id);
                cascadeData.setName((String) company.get("name"));
                cascadeData.setCurrentLevel(1);
                cascadeData.setSubTitle(LocaleUtil.getMobileTextByKey(locale, "公司"));
                if (!StringUtils.hasLength(cascadeData.getSelectId())) {
                    cascadeData.setSelectId(id);
                }
                if (factorys != null && !factorys.isEmpty()) {
                    List<InputCascadeData> childDataList = new ArrayList<>(factorys.size());
                    for (Map<String, Object> factory : factorys) {
                        if (id.equals(factory.get("companyId"))) {
                            InputCascadeData childCascadeData = new InputCascadeData();
                            childCascadeData.setSchema(secondSchema);
                            childCascadeData.setId((String) factory.get("id"));
                            childCascadeData.setName((String) factory.get("name"));
                            childCascadeData.setCurrentLevel(2);
                            childCascadeData.setSubTitle(LocaleUtil.getMobileTextByKey(locale, "工厂"));
                            if (!StringUtils.hasLength(childCascadeData.getSelectId())) {
                                cascadeData.setSelectId((String) factory.get("id"));
                            }
                            childDataList.add(childCascadeData);
                        }
                    }
                    cascadeData.setChildDataList(childDataList);
                    inputCascade.setLevelNums(levelNums);
                } else {
                    cascadeData.setChildDataList(Collections.emptyList());
                    inputCascade.setLevelNums(1);
                }
                // 排除无二级的据点
                if (!CollectionUtils.isEmpty(cascadeData.getChildDataList())) {
                    dataList.add(cascadeData);
                }
            }
            inputCascade.setDataList(dataList);
            if (CollectionUtils.isEmpty(dataList)) {
                inputCascade.setLevelNums(0);
            }
        } else {
            inputCascade.setLevelNums(0);
            inputCascade.setDataList(Collections.emptyList());
        }
        RelationRule relationRule = new RelationRule();
        List<CommonRule> ruleList = new ArrayList<>(1);
        CommonRule rule = new CommonRule();
        rule.setTargetSchema("except_name");
        rule.setTargetRequired(true);
        rule.setTargetSelectId("");
        rule.setTargetEnable(true);
        rule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
        ruleList.add(rule);
        relationRule.setRuleList(ruleList);
        inputCascade.setRelationRule(relationRule);
        inputCascade.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputCascade.setErrorMessage(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        // 构建默认选中项（默认选中第一个）
        inputCascade.setDefaultSelect(handleDefaultSelect(inputCascade.getDataList(), inputCascade.getLevelNums(), 1));
        return inputCascade;
    }

    private static DefaultSelect handleDefaultSelect(List<InputCascadeData> dataList, Integer levelNums, Integer level) {
        DefaultSelect defaultSelect = buildDefaultSelect(dataList, levelNums, level);
        if (defaultSelect != null) {
            // 空结构 返回null
            defaultSelect = BooleanUtils.isTrue(defaultSelect.getIsEmpty()) ? null : defaultSelect;
        }
        return defaultSelect;
    }

    /**
     * 构建默认选中项（默认选中第一个）
     *
     * @param dataList  层级数据
     * @param levelNums 总层级
     * @param level     当前层级
     * @return
     */
    private static DefaultSelect buildDefaultSelect(List<InputCascadeData> dataList, Integer levelNums, Integer level) {
        // 位置不能变更
        if ((levelNums - level) < 0) {
            return new DefaultSelect().setIsEmpty(true);
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return null;
        }
        for (InputCascadeData inputCascadeData : dataList) {
            DefaultSelect child = buildDefaultSelect(inputCascadeData.getChildDataList(), levelNums, level + 1);
            if (null == child) {
                continue;
            }
            // 存在当前levelNums下的数据才构建
            DefaultSelect parent = new DefaultSelect().setId(inputCascadeData.getId())
                    .setName(inputCascadeData.getName())
                    .setSchema(inputCascadeData.getSchema())
                    .setCurrentLevel(inputCascadeData.getCurrentLevel());
            return (levelNums - level) == 0 ? parent : parent.setChild(child);
        }
        return null;
    }

    @Override
    public String returnComponentType() {
        return InputCascade.COMPONENT_TYPE;
    }

    @Data
    @Accessors(chain = true)
    public static
    class DefaultSelect {
        private Boolean isEmpty;
        /**
         * 数据的id
         */
        private String id;
        /**
         * 数据的显示名称
         */
        private String name;

        /**
         * 对应层级的业务数据key
         */
        private String schema;

        /**
         * 当前级联的层级
         */
        private Integer currentLevel;

        /**
         * 默认下一层级选中的项
         */
        private DefaultSelect child;

    }

    /**
     * eoc列名列表 -- 设计器新增属性
     */
    private List<String> schemas;

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.type = InputCascadeTypeEnum.PARSE.getValue();
        this.style = InputCascadeSelectStyleEnum.BG_STYLE_WHITE.getValue();
        this.dataList = this.buildDataList(this.schemas);
        this.levelNums = this.buildLevelNums(this.dataList);
        // 构建默认选中项
        this.defaultSelect = handleDefaultSelect2(this.dataList, this.levelNums, 1, data, mobilePath, schema, this.schemas);
    }

    public List<InputCascadeData> buildDataList(List<String> schemas) {
        if (CollectionUtils.isEmpty(schemas) || schemas.size() < 2) {
            return Collections.emptyList();
        }
        DigiwinEocProxyService digiwinEocProxyService = SpringContextHolder.getBean(DigiwinEocProxyServiceImpl.class);
        //公司别
        List<Map<String, Object>> companys = digiwinEocProxyService.getCompany(AppRequestContext.getContextEntity().getIamUserToken());
        //工厂别
        List<Map<String, Object>> factorys = digiwinEocProxyService.getFactory(AppRequestContext.getContextEntity().getIamUserToken());
        if (CollectionUtils.isEmpty(companys)) {
            return Collections.emptyList();
        }
        LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);
        String companyTitle = localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "公司");
        String factoryTitle = localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "工厂");
        String areaTitle = localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "区域");
        List<InputCascadeData> dataList = new ArrayList<>(companys.size());
        for (Map<String, Object> company : companys) {
            InputCascadeData first = new InputCascadeData();
            String id = (String) company.get("id");
            first.setSchema(schemas.get(0));
            first.setId(id);
            first.setName((String) company.get("name"));
            first.setCurrentLevel(1);
            first.setSubTitle(companyTitle);
            if (!StringUtils.hasLength(first.getSelectId())) {
                first.setSelectId(id);
            }
            List<InputCascadeData> secondList = new ArrayList<>();
            Optional.ofNullable(factorys)
                    .orElse(new ArrayList<>())
                    .forEach(factory -> {
                        if (id.equals(factory.get("companyId"))) {
                            InputCascadeData second = new InputCascadeData();
                            second.setSchema(schemas.get(1));
                            second.setId((String) factory.get("id"));
                            second.setName((String) factory.get("name"));
                            second.setCurrentLevel(2);
                            second.setSubTitle(factoryTitle);
                            if (!StringUtils.hasLength(second.getSelectId())) {
                                second.setSelectId((String) factory.get("id"));
                            }
                            secondList.add(second);
                        }
                    });
            first.setChildDataList(secondList);
            // 排除无二级的据点
            if (!CollectionUtils.isEmpty(first.getChildDataList())) {
                dataList.add(first);
            }
        }
        if (schemas.size() > 2) {
            // 获取区域
            List<Map<String, Object>> areas = digiwinEocProxyService.getArea(AppRequestContext.getContextEntity().getIamUserToken());
            if (!CollectionUtils.isEmpty(areas)) {
                // 获取三级
                dataList.stream()
                        .flatMap(first -> first.getChildDataList().stream())
                        .forEach(second -> {
                            List<InputCascadeData> thirdList = new ArrayList<>(areas.size());
                            for (Map<String, Object> area : areas) {
                                InputCascadeData third = new InputCascadeData();
                                third.setSchema(schemas.get(2));
                                third.setId((String) area.get("id"));
                                third.setName((String) area.get("name"));
                                third.setCurrentLevel(3);
                                third.setSubTitle(areaTitle);
                                if (!StringUtils.hasLength(third.getSelectId())) {
                                    third.setSelectId((String) area.get("id"));
                                }
                                thirdList.add(third);
                            }
                            second.setChildDataList(thirdList);
                        });
            }
        }
        return dataList;
    }

    private Integer buildLevelNums(List<InputCascadeData> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return 0;
        }
        List<InputCascadeData> secondList = dataList.stream().flatMap(first -> first.getChildDataList().stream()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(secondList)) {
            return 1;
        }
        if (secondList.stream().mapToLong(third -> third.getChildDataList().size()).sum() == 0) {
            return 2;
        }
        return 3;
    }

    private static DefaultSelect handleDefaultSelect2(List<InputCascadeData> dataList, Integer levelNums, Integer level, Map<String, Object> data, String mobilePath, String schema, List<String> schemas) {
        DefaultSelect defaultSelect = buildDefaultSelect2(dataList, levelNums, level, data, mobilePath, schema, schemas);
        if (defaultSelect != null) {
            // 空结构 返回null
            defaultSelect = BooleanUtils.isTrue(defaultSelect.getIsEmpty()) ? null : defaultSelect;
        }
        return defaultSelect;
    }

    private static DefaultSelect
    buildDefaultSelect2(List<InputCascadeData> dataList, Integer levelNums, Integer level,
                        Map<String, Object> data, String mobilePath, String schema, List<String> schemas) {
        // 位置不能变更
        if ((levelNums - level) < 0) {
            return new DefaultSelect().setIsEmpty(true);
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return null;
        }

        if (StringUtils.hasLength(mobilePath)) {
            mobilePath = mobilePath.replace(schema, schemas.get(level - 1));
        }
        schema = schemas.get(level - 1);
        Object o = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        if (o == null) {
            // 默认获取第一个
            for (InputCascadeData inputCascadeData : dataList) {
                DefaultSelect child = buildDefaultSelect2(inputCascadeData.getChildDataList(), levelNums, level + 1, data, mobilePath, schema, schemas);
                if (null == child) {
                    continue;
                }
                // 存在当前levelNums下的数据才构建
                DefaultSelect parent = new DefaultSelect().setId(inputCascadeData.getId())
                        .setName(inputCascadeData.getName())
                        .setSchema(inputCascadeData.getSchema())
                        .setCurrentLevel(inputCascadeData.getCurrentLevel());
                return (levelNums - level) == 0 ? parent : parent.setChild(child);
            }
        } else {
            // 获取当前
            Optional<InputCascadeData> first = dataList.stream().filter(r -> o.toString().equals(r.getId())).findFirst();
            if (first.isPresent()) {
                InputCascadeData inputCascadeData = first.get();
                DefaultSelect child = buildDefaultSelect2(inputCascadeData.getChildDataList(), levelNums, level + 1, data, mobilePath, schema, schemas);
                if (null == child) {
                    return null;
                }
                // 存在当前levelNums下的数据才构建
                DefaultSelect parent = new DefaultSelect().setId(inputCascadeData.getId())
                        .setName(inputCascadeData.getName())
                        .setSchema(inputCascadeData.getSchema())
                        .setCurrentLevel(inputCascadeData.getCurrentLevel());
                return (levelNums - level) == 0 ? parent : parent.setChild(child);
            } else {
                // 默认获取第一个
                for (InputCascadeData inputCascadeData : dataList) {
                    DefaultSelect child = buildDefaultSelect2(inputCascadeData.getChildDataList(), levelNums, level + 1, data, mobilePath, schema, schemas);
                    if (null == child) {
                        continue;
                    }
                    // 存在当前levelNums下的数据才构建
                    DefaultSelect parent = new DefaultSelect().setId(inputCascadeData.getId())
                            .setName(inputCascadeData.getName())
                            .setSchema(inputCascadeData.getSchema())
                            .setCurrentLevel(inputCascadeData.getCurrentLevel());
                    return (levelNums - level) == 0 ? parent : parent.setChild(child);
                }
            }
        }
        return null;
    }
}
