package com.digiwin.mobile.mobileuibot.core.component.input.cascade;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class InputCascadeData implements Serializable {
    private static final long serialVersionUID = -704349668791372973L;

    /**
     * 当前级联的层级
     */
    private Integer currentLevel;
    /**
     * 数据的id
     */
    private String id;
    /**
     * 数据的显示名称
     */
    private String name;
    /**
     * 对应层级的业务数据key
     */
    private String schema;
    /**
     * 当前层级选中的id
     */
    private String selectId;
    /**
     * 当前层级显示的title
     */
    private String subTitle;
    /**
     * 请求第三方接口的url
     */
    private String url;
    /**
     * 级联的下一层数据
     */
    private List<InputCascadeData> childDataList = new ArrayList<>();
}
