package com.digiwin.mobile.mobileuibot.core.component.input.cascade;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Map;

/**
 * @author wuyang
 * @desc 省市区级联组件
 */
@Data
public class InputCascadeDistrict extends BaseInputMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "INPUT_CASCADE_DISTRICT";
    private static final long serialVersionUID = 8427512201222589114L;

    private String id;
    /**
     * 当前栏位的名称
     */
    private String title;
    /**
     * 请求的url（默认没有值，从前端本地拿，而从对应地址获取（从高德地图的接口地址））
     */
    private String requestUrl;
    /**
     * 1：显示省市区（默认）2：显示省市 ；3：显示省
     */
    private Integer districtType = InputCascadeDistrictTypeEnum.ALL_PCA.getValue();
    /**
     * 省
     */
    private String province;
    /**
     * 市
     */
    private String city;
    /**
     * 区
     */
    private String area;
    /**
     * 街道
     */
    private String street;

    public static InputCascadeDistrict create(String schema, String title, String locale,
                                              Map<String, Object> datas, boolean required, Integer type) {
        InputCascadeDistrict district = new InputCascadeDistrict();
        district.setSchema(schema);
        district.setTitle(title);
        district.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        district.setRequired(required);
        district.setDistrictType(type);
        if (!CollectionUtils.isEmpty(datas)) {
            district.setId(String.valueOf(datas.get("area_id")));
            district.setProvince((String) datas.get("province"));
            district.setCity((String) datas.get("city"));
            district.setArea((String) datas.get("area"));
        }
        return district;
    }

    @Override
    public String returnComponentType() {
        return InputCascadeDistrict.COMPONENT_TYPE;
    }
}
