package com.digiwin.mobile.mobileuibot.core.component.input.cascade;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputCascadeParamAnalyzer
 * @Author: wuyang
 * @date 20220823
 */
@Component("InputCascadeDistrictParamAnalyzer")
public class InputCascadeDistrictParamAnalyzer implements ComponentParamAnalyzer<InputCascadeDistrict, String> {

    private static final Logger logger = LoggerFactory.getLogger(InputCascadeDistrictParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputCascadeDistrict.COMPONENT_TYPE;
    }

    @Override
    public Class<InputCascadeDistrict> getSubmitParamType() {
        return InputCascadeDistrict.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputCascadeDistrict)) {
            logger.debug("submitParam is not instanceof InputCascadeDistrict component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        InputCascadeDistrict district = (InputCascadeDistrict) submitParam;
        return district.getId();
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {

    }
}
