package com.digiwin.mobile.mobileuibot.core.component.input.cascade;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputCascadeParamAnalyzer
 * @Author: wuyang
 * @date 20220823
 */
@Component("InputCascadeParamAnalyzer")
public class InputCascadeParamAnalyzer implements ComponentParamAnalyzer<InputCascade, List<Map<String, Object>>> {

    private static final Logger logger = LoggerFactory.getLogger(InputCascadeParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputCascade.COMPONENT_TYPE;
    }

    @Override
    public Class<InputCascade> getSubmitParamType() {
        return InputCascade.class;
    }

    @Override
    public List<Map<String, Object>> analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof List)) {
            logger.debug("submitParam is not instanceof InputCascade component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) submitParam;
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {

    }
}
