package com.digiwin.mobile.mobileuibot.core.component.input.cascade;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocOrg;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：运营单元组件参数解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputEocSelectParamAnalyzer.java
 * @Author: wangjwc
 * @Date: created at 2025/5/27 17:16
 */
@Component("InputEocSelectParamAnalyzer")
public class InputEocSelectParamAnalyzer implements ComponentParamAnalyzer<InputEocSelect, String> {
    private static final Logger logger = LoggerFactory.getLogger(InputEocSelectParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputEocSelect.COMPONENT_TYPE;
    }

    @Override
    public Class<InputEocSelect> getSubmitParamType() {
        return InputEocSelect.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputEocSelect)) {
            logger.debug("submitParam is not instanceof InputEocSelect component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return null;
        }
        InputEocSelect eocSelect = (InputEocSelect) submitParam;
        // wjw TODO: 2025/5/29 假设api中存储的Eoc组织信息为当前选择的组织ID
        EocOrg eocOrg = eocSelect.getData();
        if (null == eocOrg) {
            logger.debug("The data of InputEocSelect component is null...");
            return null;
        }
        return eocOrg.getId();
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {

    }
}
