package com.digiwin.mobile.mobileuibot.core.component.input.choosetaskprogress;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：进度选择组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ChooseTaskProgress
 * @Author: Zaregoto
 * @Date: 2021/5/25 22:14
 */
public class ChooseTaskProgress extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = 1546124926330701170L;
    public static final String COMPONENT_TYPE = "CHOOSE_TASK_PROGRESS";

    private String chosenId;
    private String defaultId;
    private List<TaskProgress> taskProgressList;

    public ChooseTaskProgress() {
    }

    public static ChooseTaskProgress create(String locale, List<TaskProgress> taskProgressList) {
        ChooseTaskProgress chooseTaskProgress = new ChooseTaskProgress();
        chooseTaskProgress.setTaskProgressList(taskProgressList);

        return chooseTaskProgress;
    }

    public static ChooseTaskProgress createReassignReport(String locale, List<DigiwinReassignReport> reassignReportList) {
        ChooseTaskProgress chooseTaskProgress = new ChooseTaskProgress();
        List<TaskProgress> taskProgressList = new ArrayList<>(reassignReportList.size());
        for (int i = 0; i < reassignReportList.size(); i++) {
            if (i == 0) {
                taskProgressList.add(TaskProgress.create(locale, reassignReportList.get(i), TaskProgressStateEnum.DOING.getValue()));
            } else {
                taskProgressList.add(TaskProgress.create(locale, reassignReportList.get(i), TaskProgressStateEnum.DONE.getValue()));
            }

        }
        chooseTaskProgress.setTaskProgressList(taskProgressList);

        return chooseTaskProgress;
    }

    public String getChosenId() {
        return chosenId;
    }

    public void setChosenId(String chosenId) {
        this.chosenId = chosenId;
    }

    public String getDefaultId() {
        return defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public List<TaskProgress> getTaskProgressList() {
        return taskProgressList;
    }

    public void setTaskProgressList(List<TaskProgress> taskProgressList) {
        this.taskProgressList = taskProgressList;
    }

    @Override
    public String returnComponentType() {
        return ChooseTaskProgress.COMPONENT_TYPE;
    }
}
