package com.digiwin.mobile.mobileuibot.core.component.input.choosetaskprogress;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.bpm.model.DigiwinBpmRedoTask;
import com.digiwin.mobile.mobileuibot.proxy.bpm.service.DigiwinBpmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.taskengine.model.DigiwinTaskEngineActivity;
import com.digiwin.mobile.mobileuibot.proxy.taskengine.model.DigiwinTaskEngineWorkitem;
import com.digiwin.mobile.mobileuibot.proxy.taskengine.service.DigiwinTaskEngineProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressPerson;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ChooseTaskProgressSubmitParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/5/25 20:25
 */
@Component("chooseTaskProgressParamAnalyzer")
public class ChooseTaskProgressParamAnalyzer implements ComponentParamAnalyzer<ChooseTaskProgress, String> {

    private static final Logger logger = LoggerFactory.getLogger(
            ChooseTaskProgressParamAnalyzer.class);

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigiwinBpmProxyService digiwinBpmProxyService;

    @Autowired
    private DigiwinTaskEngineProxyService digiwinTaskEngineProxyService;

    @Override
    public String getComponentType() {
        return ChooseTaskProgress.COMPONENT_TYPE;
    }

    @Override
    public Class<ChooseTaskProgress> getSubmitParamType() {
        return ChooseTaskProgress.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof ChooseTaskProgress)) {
            logger.debug("submitParam is not instanceof ChooseTaskProgress component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        ChooseTaskProgress chooseTaskProgress = (ChooseTaskProgress) submitParam;
        return Optional.ofNullable(chooseTaskProgress.getChosenId()).orElse("");
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {
        Map<String, Object> data = (Map<String, Object>) apiRequest.getRawData().get("data");

        Map<String, Object> requestData = new HashMap<>();
        Map<String, Object> actionMap = (Map<String, Object>) apiRequest.getRawData().get("action");
        if (actionMap != null) {
            Map<String, Object> extendedFields = (Map<String, Object>) actionMap.get("extendedFields");
            if (extendedFields != null) {
                requestData = (Map<String, Object>) extendedFields.get("reexecuteData");
            }
        }
        String dataFrom = null;
        if (actionMap != null && actionMap.get("executeContext") != null) {
            dataFrom = (String) ((HashMap) actionMap.get("executeContext")).get("dataFrom");
        }
        ChooseTaskProgress chooseTaskProgress = new ChooseTaskProgress();
        if ("PTM".equalsIgnoreCase(dataFrom)) {
            //模型驱动2.0签核卡退回的历程信息需要的workitemId可能paras没有，需要从attachActions中获取
            String workitemId = Optional.ofNullable(actionMap.get("paras"))
                    .map(e -> {
                        Map<String, Object> parasMap = (Map<String, Object>) e;
                        return MapUtils.getString(parasMap, "workitemId");
                    }).orElse("");
            if (!StringUtils.hasLength(workitemId)) {
                List<Map<String, Object>> attachActions = (List<Map<String, Object>>) MapUtil.getOrDefault(actionMap,
                        "attachActions", Collections.emptyList());
                if (!CollectionUtils.isEmpty(attachActions)) {
                    for (Map<String, Object> attachAction : attachActions) {
                        Optional<String> workitemIdOpt = Optional.ofNullable(attachAction.get("paras"))
                                .map(e -> {
                                    Map<String, Object> parasMap = (Map<String, Object>) e;
                                    return MapUtils.getString(parasMap, "workitemId");
                                });
                        if (workitemIdOpt.isPresent()) {
                            workitemId = workitemIdOpt.get();
                            break;
                        }
                    }
                }
            }
            if (!StringUtils.hasLength(workitemId)) {
                return;
            }
            List<DigiwinTaskEngineActivity> activities = null;
            if (this.isBizDataEntryDriven(actionMap)) {
                // 数据录入-流程设计-生成的人工签核卡
                activities = digiwinTaskEngineProxyService.getPtmActivityList(apiRequest.getLocale(), apiRequest.getIamUserToken(), workitemId);
            } else {
                activities = digiwinTaskEngineProxyService.getTaskEngineActivityList(apiRequest.getLocale(), apiRequest.getIamUserToken(), workitemId);
            }
            if (!CollectionUtils.isEmpty(activities)) {
                List<TaskProgress> progressList = activities.stream().map(activity -> {
                    TaskProgress taskProgress = new TaskProgress();
                    taskProgress.setId(activity.getActivityId());
                    taskProgress.setName(activity.getActivityName());
                    taskProgress.setState(TaskProgressStateEnum.DONE.getValue());
                    List<DigiwinTaskEngineWorkitem> workitemList = activity.getWorkitemList();
                    if (!CollectionUtils.isEmpty(workitemList)) {
                        List<TaskProgressPerson> personList = new ArrayList<>();
                        for (DigiwinTaskEngineWorkitem workitem : workitemList) {
                            TaskProgressPerson progressPerson = new TaskProgressPerson();
                            progressPerson.setName(digiwinEocProxyService.getEocPersonInfo(workitem.getPerformerId(), apiRequest.getIamUserToken(), 2).getName());
                            personList.add(progressPerson);
                        }
                        taskProgress.setPersonList(personList);
                    }
                    return taskProgress;
                }).collect(Collectors.toList());
                chooseTaskProgress.setTaskProgressList(progressList);
            }
        } else {
            //任务引擎
            List<DigiwinBpmRedoTask> taskList = digiwinBpmProxyService.getRedoList(
                    apiRequest.getLocale(),
                    apiRequest.getIamUserToken(),
                    requestData);
            if (taskList != null) {
                List<TaskProgress> progressList = taskList.stream().map(task -> {
                    TaskProgress taskProgress = new TaskProgress();
                    taskProgress.setId(task.getBpmActivityId());
                    taskProgress.setName(task.getBpmActivityName());
                    taskProgress.setState(TaskProgressStateEnum.DONE.getValue());
                    String pid = task.getPerformer();
                    List<TaskProgressPerson> personList = new ArrayList<>();
                    TaskProgressPerson progressPerson = new TaskProgressPerson();
                    progressPerson.setName(digiwinEocProxyService.getEocPersonInfo(pid, apiRequest.getIamUserToken(), 2).getName());
                    personList.add(progressPerson);
                    taskProgress.setPersonList(personList);
                    return taskProgress;
                }).collect(Collectors.toList());
                chooseTaskProgress.setTaskProgressList(progressList);
            }
            pageData.put(pageDataKey, chooseTaskProgress);
        }
        pageData.put(pageDataKey, chooseTaskProgress);
    }

    private boolean isBizDataEntryDriven(Map<String, Object> actionMap) {
        if (actionMap == null) {
            return false;
        }
        Map<String, Object> executeContext = (Map<String, Object>) actionMap.get("executeContext");
        if (executeContext == null) {
            return false;
        }
        String category = StringUtil.valueOf(executeContext.get("category"));
        String pattern = StringUtil.valueOf(executeContext.get("pattern"));
        return TaskStringUtil.isBizDataEntryDriven(pattern, category);
    }
}
