package com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * <p>功能描述：日期时间实体类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputDateTime
 * @Author: Zaregoto
 * @Date: 2021/9/6 1:02
 */
public class InputDateTime implements Serializable {
    private static final long serialVersionUID = 7602699630128224930L;

    private static final Integer YEAR_MONTH_DATE_SIZE = 3;
    private static final Integer HOUR_MIN_SIZE = 2;

    private String year;
    private String month;
    private String date;
    private String hour;
    private String minute;
    private Integer type;

    public InputDateTime() {
    }

    public InputDateTime(String year, String month, String date, String hour, String minute) {
        this.year = year;
        this.month = month;
        this.date = date;
        this.hour = hour;
        this.minute = minute;
    }

    public InputDateTime(String year, String month, String date, String hour) {
        this.year = year;
        this.month = month;
        this.date = date;
        this.hour = hour;
    }

    public InputDateTime(String year, String month, String date) {
        this.year = year;
        this.month = month;
        this.date = date;
    }

    public InputDateTime(String year, String month, String date, String hour, String minute, Integer type) {
        this.year = year;
        this.month = month;
        this.date = date;
        this.hour = hour;
        this.minute = minute;
        this.type = type;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getHour() {
        return hour;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public String getMinute() {
        return minute;
    }

    public void setMinute(String minute) {
        this.minute = minute;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 废弃，根据类型转换对应字符串，不应自动补全年月日时分秒
     */
    @Deprecated
    public static String getDateStringByType(InputDateTime inputDateTime, Integer dateType) {
        Integer type = inputDateTime.getType();
        if (dateType != null) {
            type = dateType;
        }
        String dataValue = "";
        inputDateTime.setMonth(coverTime(inputDateTime.getMonth()));
        inputDateTime.setHour(coverTime(inputDateTime.getHour()));
        inputDateTime.setMinute(coverTime(inputDateTime.getMinute()));
        if (InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType().equals(type)) {
            dataValue = inputDateTime.getYear() + "-" + inputDateTime.getMonth() +
                    "-" + inputDateTime.getDate() + " " + inputDateTime.getHour() + ":" + inputDateTime.getMinute() + ":00";
        } else if (InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR.getType().equals(type)) {
            dataValue = inputDateTime.getYear() + "-" + inputDateTime.getMonth() +
                    "-" + inputDateTime.getDate() + " " + inputDateTime.getHour() + ":00:00";
        } else if (InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType().equals(type)) {
            dataValue = inputDateTime.getYear() + "-" + inputDateTime.getMonth() +
                    "-" + inputDateTime.getDate() + " 00:00:00";
        } else if (InputDateTimePickerTypeEnum.HOUR_MINUTE.getType().equals(type)) {
            dataValue = inputDateTime.getHour() + ":" + inputDateTime.getMinute() + ":00";
        }
        return dataValue;
    }

    public static String getDateTypeDateStringByType(InputDateTime inputDateTime, Integer dateType) {
        Integer type = inputDateTime.getType();
        if (dateType != null) {
            type = dateType;
        }
        String dataValue = "";
        inputDateTime.setMonth(coverTime(inputDateTime.getMonth()));
        inputDateTime.setHour(coverTime(inputDateTime.getHour()));
        inputDateTime.setMinute(coverTime(inputDateTime.getMinute()));
        if (InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType().equals(type)) {
            dataValue = inputDateTime.getYear() + "-" + inputDateTime.getMonth() +
                    "-" + inputDateTime.getDate() + " " + inputDateTime.getHour() + ":" + inputDateTime.getMinute() + ":00";
        } else if (InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR.getType().equals(type)) {
            dataValue = inputDateTime.getYear() + "-" + inputDateTime.getMonth() +
                    "-" + inputDateTime.getDate() + " " + inputDateTime.getHour();
        } else if (InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType().equals(type)) {
            dataValue = inputDateTime.getYear() + "-" + inputDateTime.getMonth() +
                    "-" + inputDateTime.getDate();
        } else if (InputDateTimePickerTypeEnum.HOUR_MINUTE.getType().equals(type)) {
            dataValue = inputDateTime.getHour() + ":" + inputDateTime.getMinute();
        }
        return dataValue;
    }

    private static String coverTime(String time) {
        if (time != null && time.length() < 2) {
            return "0" + time;
        } else {
            return time;
        }
    }

    public static InputDateTime create(String date, Integer dateType) {
        InputDateTime inputDateTime = new InputDateTime();
        if (!StringUtils.hasLength(date)) {
            date = DateTimeUtil.currentDateAddYears(null, 0);
        }
        if (InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType().equals(dateType)) {
            if (date.contains("-")) {
                return setDateTimeByYearMonthDate(inputDateTime, date.split("-"));
            } else if (date.contains("/")) {
                return setDateTimeByYearMonthDate(inputDateTime, date.split("/"));
            }
        } else if (InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType().equals(dateType)) {
            if (date.contains("-")) {
                inputDateTime = setDateTimeByYearMonthDate(inputDateTime, date.split("-"));
                inputDateTime = setDateTimeByHourMin(inputDateTime, date.split(":"));
            }
            if (date.contains("/")) {
                inputDateTime = setDateTimeByYearMonthDate(inputDateTime, date.split("/"));
                inputDateTime = setDateTimeByHourMin(inputDateTime, date.split(":"));
            }
        }
        inputDateTime.setType(dateType);
        return inputDateTime;
    }

    private static InputDateTime setDateTimeByHourMin(InputDateTime inputDateTime, String[] dates) {
        if (dates != null && dates.length >= HOUR_MIN_SIZE) {
            inputDateTime.setHour(dates[0].split(" ")[1]);
            inputDateTime.setMinute(dates[1]);
        }
        return inputDateTime;
    }

    private static InputDateTime setDateTimeByYearMonthDate(InputDateTime inputDateTime, String[] dates) {
        if (dates != null && dates.length >= YEAR_MONTH_DATE_SIZE) {
            inputDateTime.setYear(dates[0]);
            inputDateTime.setMonth(dates[1]);
            inputDateTime.setDate(dates[2].split(" ")[0]);
            return inputDateTime;
        }
        return inputDateTime;
    }
}
