package com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.TargetDatetime;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.UiBotField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * <p>功能描述：日期时间选择组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputDateTimePicker
 * @Author: Zaregoto
 * @Date: 2021/9/6 1:00
 */
@Data
public class InputDateTimePicker extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = 6299848542524688780L;
    public static final String COMPONENT_TYPE = "INPUT_DATETIME_PICKER";


    @Override
    public String returnComponentType() {
        return InputDateTimePicker.COMPONENT_TYPE;
    }

    /**
     * 单选时的时间值
     */
    private InputDateTime datetimeValue;
    /**
     * 区间选择的时间值
     * 注意：此字段未使用，因为前端不支持区间选择，choice属性一直是单选，所以此属性未使用
     */
    private List<InputDateTime> datetimeValues;
    private InputDateTime minDatetime;
    private InputDateTime maxDatetime;
    /**
     * 默认回填的时间值（单选）
     */
    private InputDateTime selectDefaultDatetime;
    /**
     * 默认回填的时间值（多选）
     */
    private List<InputDateTime> selectDefaultDatetimes;
    private String title;
    private Integer type = InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType();
    /**
     * 选择类型
     * SINGLE_CHOICE：单选（默认）；
     * MULTIPLE_CHOICE：区间选择；
     * 注意：日期时间选择组件，前端不支持区间选择，故后端给任何值，前端都当成单选处理
     */
    private String choice = MultiFunctionListChoiceEnum.SINGLE_CHOICE.toString();


    public InputDateTimePicker() {
    }

    public static InputDateTimePicker create(String schema, String headerName, Object bizData, String locale, Integer type) {
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setSchema(schema);
        inputDateTimePicker.setTitle(headerName);
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请选择"),
                headerName,
                "")
        );
        inputDateTimePicker.setType(type);
        inputDateTimePicker.setEnable(true);
        inputDateTimePicker.setDatetimeValue(InputDateTime.create((String) bizData, type));
        inputDateTimePicker.setRequired(true);
        return inputDateTimePicker;
    }

    public static InputDateTimePicker create(String schema, String headerName, String data, String locale, Integer type) {
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setSchema(schema);
        inputDateTimePicker.setTitle(headerName);
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setType(type);
        inputDateTimePicker.setEnable(true);
        if (!StringUtils.isEmpty(data)) {
            inputDateTimePicker.setDatetimeValue(InputDateTime.create(data, type));
        }
        inputDateTimePicker.setRequired(true);
        return inputDateTimePicker;
    }

    public static InputDateTimePicker create(String schema, String headerName,
                                             Object bizData, String locale, Integer type,
                                             String startSchema, String endSchema) {
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setSchema(schema);
        inputDateTimePicker.setTitle(headerName);
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请选择"),
                headerName,
                "")
        );
        inputDateTimePicker.setType(type);
        inputDateTimePicker.setEnable(true);
        inputDateTimePicker.setDatetimeValue(InputDateTime.create((String) bizData, type));
        inputDateTimePicker.setRequired(true);
        List<CommonRule> ruleLists = inputDateTimePicker.getRelationRule().getRuleList();
        if (startSchema.equalsIgnoreCase(schema)) {
            //开始日期有变化则需要置空实际结束日期
            CommonRule commonRule = new CommonRule();
            commonRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
            commonRule.setTargetSchema(endSchema);
            commonRule.setTargetText("");
            commonRule.setTargetHidden(null);
            commonRule.setTargetEnable(true);
            //防呆，选择的时间不能小于开始的时间
            List<TargetDatetime> targetDatetimes = new ArrayList<>();
            TargetDatetime targetDatetime = new TargetDatetime();
            targetDatetime.setDatetimeType(1);
            targetDatetime.setLinkageSchema(startSchema);
            targetDatetimes.add(targetDatetime);
            commonRule.setTargetDatetime(targetDatetimes);
            ruleLists.add(commonRule);
        }

        return inputDateTimePicker;
    }

    public static InputDateTimePicker create(String schema, String headerName,
                                             Object bizData, String locale, Integer type,
                                             Boolean enable, List<UiBotRule> ruleList) {
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setSchema(schema);
        inputDateTimePicker.setTitle(headerName);
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请选择"),
                headerName,
                "")
        );
        inputDateTimePicker.setType(type);
        inputDateTimePicker.setDatetimeValue(InputDateTime.create((String) bizData, type));
        inputDateTimePicker.setEnable(enable == null ? false : enable);
        if (ruleList != null && ruleList.size() > 0) {
            ruleList.stream().filter(uiBotRule -> schema.equalsIgnoreCase(uiBotRule.getSchema()))
                    .forEach(uiBotRule -> {
                        if (ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(uiBotRule.getKey())) {
                            inputDateTimePicker.setRequired("required".equalsIgnoreCase(uiBotRule.getKey()));
                        }
                    });
        }
        return inputDateTimePicker;
    }

    public static InputDateTimePicker create(UiBotLayout uiBotLayout, Map<String, Object> data, String locale, String selectDate, Boolean isComplete) {
        RelationRule relationRule = new RelationRule();
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setSchema(uiBotLayout.getSchema());
        inputDateTimePicker.setTitle(uiBotLayout.getmLabelText().get(locale));
        if ("actualStartTime".equals(uiBotLayout.getSchema())) {
            inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "计划开始"));
        } else if ("actualEndTime".equals(uiBotLayout.getSchema())) {
            inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "计划结束"));
        } else {
            inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        }
        inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请选择"),
                uiBotLayout.getmLabelText().get(locale),
                "")
        );
        inputDateTimePicker.setRequired(true);
        LocalDateTime now;
        InputDateTime nowInputDt;
        if (StringUtils.hasLength(selectDate)) {
            now = DateTimeUtil.parseUseDefaultPattern(selectDate);
        } else {
            now = LocalDateTime.now();
        }

        String dataTime = (String) data.get(uiBotLayout.getSchema());
        if ("startTime".equals(uiBotLayout.getSchema())) {
            nowInputDt = setInputDt(now, 1);
            inputDateTimePicker.setRelationRule(buildRelationRule("isAllDay", "startTime", "endTime", CommonRuleCondition.CONDITION_VALIDATE_LINKAGE.getType(), 3, relationRule, "23:59:00", isComplete));
            inputDateTimePicker.setRelationRule(buildRelationRule("endTime", "startTime", "endTime", CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType(), 1, relationRule, "23:59:00", isComplete));
        } else if ("actualStartTime".equals(uiBotLayout.getSchema())) {
            nowInputDt = setInputDt(now, 1);
            inputDateTimePicker.setRelationRule(buildRelationRule("isAllDay", "actualStartTime", "actualEndTime", CommonRuleCondition.CONDITION_VALIDATE_LINKAGE.getType(), 3, relationRule, "23:59:00", isComplete));
            inputDateTimePicker.setRelationRule(buildRelationRule("actualEndTime", "actualStartTime", "actualEndTime", CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType(), 1, relationRule, "23:59:00", isComplete));
        } else if ("actualEndTime".equals(uiBotLayout.getSchema())) {
            nowInputDt = setInputDt(now, 2);
            inputDateTimePicker.setRelationRule(buildRelationRule("isAllDay", "actualEndTime", "actualStartTime", CommonRuleCondition.CONDITION_VALIDATE_LINKAGE.getType(), 3, relationRule, "00:00:00", isComplete));
        } else if ("endTime".equals(uiBotLayout.getSchema())) {
            nowInputDt = setInputDt(now, 2);
            inputDateTimePicker.setRelationRule(buildRelationRule("isAllDay", "endTime", "startTime", CommonRuleCondition.CONDITION_VALIDATE_LINKAGE.getType(), 3, relationRule, "00:00:00", isComplete));
        } else {
            now = LocalDateTime.now();
            nowInputDt = new InputDateTime(
                    now.getYear() + "",
                    DateTimeUtil.getFullMonth(now.getMonthValue()),
                    DateTimeUtil.getFullDate(now.getDayOfMonth()),
                    DateTimeUtil.getFullHour(now.getHour()),
                    DateTimeUtil.getFullMinute(now.getMinute())
            );
        }
        if (StringUtils.hasLength(dataTime)) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime parseTime = LocalDateTime.parse(dataTime, df);
            nowInputDt = new InputDateTime(parseTime.getYear() + "", DateTimeUtil.getFullMonth(parseTime.getMonthValue()),
                    DateTimeUtil.getFullDate(parseTime.getDayOfMonth()),
                    DateTimeUtil.getFullHour(parseTime.getHour()),
                    DateTimeUtil.getFullMinute(parseTime.getMinute())
            );
        }
        inputDateTimePicker.setDatetimeValue(nowInputDt);
        inputDateTimePicker.setType(InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType());
        inputDateTimePicker.setEnable(!isComplete);
        return inputDateTimePicker;
    }

    private static InputDateTime setInputDt(LocalDateTime now, int addTime) {
        InputDateTime nowInputDt;
        if (LocalDateTime.now().getMinute() != 0) {
            nowInputDt = new InputDateTime(
                    now.getYear() + "",
                    DateTimeUtil.getFullMonth(now.getMonthValue()),
                    DateTimeUtil.getFullDate(now.getDayOfMonth()),
                    DateTimeUtil.getFullHour(LocalDateTime.now().getHour() + addTime),
                    "00"
            );
        } else {
            nowInputDt = new InputDateTime(
                    now.getYear() + "",
                    DateTimeUtil.getFullMonth(now.getMonthValue()),
                    DateTimeUtil.getFullDate(now.getDayOfMonth()),
                    DateTimeUtil.getFullHour(LocalDateTime.now().getHour() + addTime - 1),
                    "00"
            );
        }
        return nowInputDt;
    }

    @Deprecated
    private static RelationRule buildRelationRule(String targetSchema, String selfSchema, String schema, int condition, int dateTimeType, RelationRule relationRule, String dateTime, Boolean isComplete) {
        List<CommonRule> ruleList = relationRule.getRuleList();

        CommonRule commonRule = new CommonRule();
        commonRule.setTargetEnable(!isComplete);
        commonRule.setTargetSchema(targetSchema);
        commonRule.setCondition(condition);


        //防呆，选择的时间不能小于开始的时间
        List<TargetDatetime> targetDatetimes = new ArrayList<>();
        TargetDatetime targetDatetime = new TargetDatetime();
        targetDatetime.setDatetimeType(dateTimeType);
        targetDatetime.setLinkageSchema(selfSchema);
        targetDatetimes.add(targetDatetime);
        commonRule.setTargetDatetime(targetDatetimes);

        if (condition == CommonRuleCondition.CONDITION_VALIDATE_LINKAGE.getType()) {
            commonRule.setTargetText("1");
            commonRule.setElseTargetText("0");
            List<ValidateRule> validateRules = new ArrayList<>();
            ValidateRule validateRule = new ValidateRule();
            validateRule.setType(ValidateRuleTypeEnum.TIMESPACE.getType());
            validateRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            //时间间隔为23小时59分钟
            validateRule.setParameter("1439");
            validateRule.setSchema(schema);
            validateRules.add(validateRule);

            //指定时间规则
            ValidateRule validateRule1 = new ValidateRule();
            validateRule1.setSchema(schema);
            validateRule1.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            validateRule1.setType(ValidateRuleTypeEnum.APPOINT.getType());
            validateRule1.setParameter(dateTime);
            validateRules.add(validateRule1);

            commonRule.setValidateRuleList(validateRules);
        }

        ruleList.add(commonRule);
        relationRule.setRuleList(ruleList);
        return relationRule;
    }

    public static InputDateTimePicker create(UiBotField uiBotField,
                                             List<UiBotRule> ruleList,
                                             String locale) {
        String schema = uiBotField.getSchema();
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setSchema(schema);
        inputDateTimePicker.setTitle(uiBotField.getHeaderName());
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请选择"),
                uiBotField.getHeaderName(),
                "")
        );
//        inputDateTimePicker.setType(inputDateTimePickerTypeEnum.getType());
        Optional<UiBotRule> requiredRuleList = ruleList.stream().filter(uiBotRule -> "required".equalsIgnoreCase(uiBotRule.getKey())
                && schema.equalsIgnoreCase(uiBotRule.getSchema())).findFirst();
        inputDateTimePicker.setRequired(requiredRuleList.isPresent());
        return inputDateTimePicker;
    }

    public static InputDateTimePicker create(UiBotLayout uiBotLayout,
                                             Boolean required,
                                             String locale, Integer type) {
        String schema = uiBotLayout.getSchema();
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setSchema(schema);
        inputDateTimePicker.setTitle(uiBotLayout.getHeaderName());
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请选择"),
                uiBotLayout.getHeaderName(),
                "")
        );
        inputDateTimePicker.setType(type);
        inputDateTimePicker.setRequired(required);
        return inputDateTimePicker;
    }

    public static InputDateTimePicker create(UiBotLayout uiBotLayout, Boolean required,
                                             String locale, Integer type, String maxDate,
                                             String minDate, List<Rule> mobileRuleList) {
        RelationRule relationRule = new RelationRule();
        String schema = uiBotLayout.getSchema();
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setSchema(schema);
        inputDateTimePicker.setTitle(uiBotLayout.getHeaderName());
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请选择"),
                uiBotLayout.getHeaderName(),
                "")
        );
        if (mobileRuleList != null && mobileRuleList.size() > 0) {
            for (Rule rule : mobileRuleList) {
                if (rule.getSchema().equals(schema)) {
                    List<CommonRule> ruleList = relationRule.getRuleList();
                    ruleList.add(rule.getCommonRule());
                    inputDateTimePicker.setRelationRule(relationRule);
                }
            }
        }
        if (StringUtils.hasLength(maxDate)) {
            String[] dates = maxDate.split("-");
            InputDateTime inputDateTime = new InputDateTime();
            inputDateTime.setType(InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType());
            inputDateTime.setYear(dates[0]);
            //暂时写死12月31日
            inputDateTime.setMonth("12");
            inputDateTime.setDate("31");
            inputDateTimePicker.setMaxDatetime(inputDateTime);
        }
        if (StringUtils.hasLength(minDate)) {
            String[] dates = minDate.split("-");
            InputDateTime inputDateTime = new InputDateTime();
            inputDateTime.setType(InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType());
            inputDateTime.setYear(dates[0]);
            inputDateTime.setMonth(dates[1]);
            String[] times = dates[2].split(" ");
            inputDateTime.setDate(times[0]);
            if (times.length > 1) {
                inputDateTime.setType(InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType());
                String[] split = times[1].split(":");
                inputDateTime.setHour(split[0]);
                inputDateTime.setMinute(split[1]);
            }
            inputDateTimePicker.setMinDatetime(inputDateTime);
        }
        // 结束时间不给默认值
        if (!"datetime_e".equalsIgnoreCase(schema)) {
            inputDateTimePicker.setDatetimeValue(InputDateTime.create(DateTimeUtil.getTodayTimeUseDefaultPattern(), type));
        }
        inputDateTimePicker.setType(type);
        inputDateTimePicker.setRequired(required);
        return inputDateTimePicker;
    }

    public static InputDateTimePicker create(String schema,
                                             Boolean required,
                                             String locale, Integer type, String headerName) {
        RelationRule relationRule = new RelationRule();
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setSchema(schema);
        inputDateTimePicker.setTitle(headerName);
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请选择"),
                headerName,
                "")
        );
        inputDateTimePicker.setType(type);
        inputDateTimePicker.setRequired(required);
        if ("time_start".equals(schema)) {
            inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "计划开始"));
            inputDateTimePicker.setRelationRule(buildRelationRule("time_end", "time_start", "time_end", CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType(), 1, relationRule, "", false));
        } else if ("time_end".equals(schema)) {
            inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "计划结束"));
        } else {
            inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        }
        inputDateTimePicker.setHidden(false);
        inputDateTimePicker.setEnable(true);

        return inputDateTimePicker;
    }

    public static InputDateTimePicker createZtbDeliveryDate(String schema,
                                                            Boolean required,
                                                            String locale, Integer type, String headerName) {
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setSchema(schema);
        inputDateTimePicker.setTitle(headerName);
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请选择"),
                headerName,
                "")
        );

        //设置最小选择时间
        String[] nowDates = DateTimeUtil.getTodayUseDefaultPattern().split("-");
        InputDateTime minDatetime = new InputDateTime();
        minDatetime.setType(type);
        minDatetime.setYear(nowDates[0]);
        minDatetime.setMonth(nowDates[1]);
        minDatetime.setDate(nowDates[2]);
        inputDateTimePicker.setMinDatetime(minDatetime);

        inputDateTimePicker.setType(type);
        inputDateTimePicker.setRequired(required);
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setHidden(false);
        inputDateTimePicker.setEnable(true);

        return inputDateTimePicker;
    }


    public static InputDateTimePicker create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList,
                                             Map<String, Object> bizData, List<Rule> mobileRuleList) {
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setTitle(column.getHeaderName());
        inputDateTimePicker.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputDateTimePicker.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请选择"),
                column.getHeaderName(),
                "")
        );
        // TODO 需要根据pc uibot接口设置类型
        //        inputDateTimePicker.setType();
        Optional<Rule> optRequiredRule = mobileRuleList.stream()
                .filter(r ->
                        RuleCategoryEnum.VALIDATE.getCategory().equalsIgnoreCase(r.getCategory())
                                && ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(r.getType())
                ).findFirst();
        if (optRequiredRule.isPresent()) {
            inputDateTimePicker.setRequired(true);
        } else {
            inputDateTimePicker.setRequired(false);
        }

        // TODO 需要根据pc uibot接口设置带入的值
        LocalDateTime now = LocalDateTime.now();
        InputDateTime nowInputDt = new InputDateTime(
                now.getYear() + "",
                DateTimeUtil.getFullMonth(now.getMonthValue()),
                DateTimeUtil.getFullDate(now.getDayOfMonth()),
                DateTimeUtil.getFullHour(now.getHour()),
                DateTimeUtil.getFullMinute(now.getMinute())
        );
        inputDateTimePicker.setDatetimeValue(nowInputDt);

        Long periodValue = 6L;
        // TODO 需要根据pc uibot接口设置最小值
        LocalDateTime min = now.minusMonths(periodValue);
        InputDateTime minInputDt = new InputDateTime(
                min.getYear() + "",
                DateTimeUtil.getFullMonth(min.getMonthValue()),
                DateTimeUtil.getFullDate(min.getDayOfMonth()),
                DateTimeUtil.getFullHour(min.getHour()),
                DateTimeUtil.getFullMinute(min.getMinute())
        );
        inputDateTimePicker.setMinDatetime(minInputDt);

        // TODO 需要根据pc uibot接口设置最大值
        LocalDateTime max = now.plusMonths(periodValue);
        InputDateTime maxInputDt = new InputDateTime(
                max.getYear() + "",
                DateTimeUtil.getFullMonth(max.getMonthValue()),
                DateTimeUtil.getFullDate(max.getDayOfMonth()),
                DateTimeUtil.getFullHour(max.getHour()),
                DateTimeUtil.getFullMinute(max.getMinute())
        );
        inputDateTimePicker.setMaxDatetime(maxInputDt);
        // TODO 需要与产品讨论校验规则
//        inputDateTimePicker.setValidateRuleList();

        return inputDateTimePicker;
    }

    public static InputDateTimePicker createEmpty() {
        return new InputDateTimePicker();
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        Object o = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
//        // wjw FIXME: 2023/7/27 日期选择构建
//        if (BooleanUtils.isTrue(this.enable)) {
//            if (Objects.equals(MultiFunctionListChoiceEnum.SINGLE_CHOICE.toString(), this.choice)) {
//                //只读:单选默认展示值
//                if (ObjectUtils.isNotEmpty(o)) {
//                    this.setDatetimeValue(InputDateTime.create(StringUtil.valueOf(o), type));
//                }
//            }
//        } else {
//            if (Objects.equals(MultiFunctionListChoiceEnum.SINGLE_CHOICE.toString(), this.choice)) {
//                //只读:单选默认展示值
//                if (ObjectUtils.isNotEmpty(o)) {
//                    this.setDatetimeValue(InputDateTime.create(StringUtil.valueOf(o), type));
//                }
//            }
//        }
        if (Objects.equals(MultiFunctionListChoiceEnum.SINGLE_CHOICE.toString(), this.choice)) {
            //只读:单选默认展示值
            if (ObjectUtils.isNotEmpty(o)) {
                this.setDatetimeValue(InputDateTime.create(StringUtil.valueOf(o), type));
            }
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
        inputDateTimePicker.setComponentId(rawContent.getComponentId());
        inputDateTimePicker.setTitle(rawContent.getLabel());
        inputDateTimePicker.setEnable(rawContent.getEditable());
        inputDateTimePicker.setPlaceholder("");
        Card.DesignerRawCard.Content.DateTimePickerObj datetimePickerObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.DateTimePickerObj.class);
        if (datetimePickerObj != null) {
            inputDateTimePicker.setType(datetimePickerObj.getType());
            inputDateTimePicker.setPlaceholder(datetimePickerObj.getPlaceholder());
        }
        inputDateTimePicker.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return inputDateTimePicker;
    }
}
