package com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputDateTimePickerParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/9/6 1:09
 */
@Component
public class InputDateTimePickerParamAnalyzer implements ComponentParamAnalyzer<InputDateTimePicker, InputDateTime> {

    private static final Logger logger = LoggerFactory.getLogger(InputDateTimePickerParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputDateTimePicker.COMPONENT_TYPE;
    }

    @Override
    public Class<InputDateTimePicker> getSubmitParamType() {
        return InputDateTimePicker.class;
    }

    @Override
    public InputDateTime analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputDateTimePicker)) {
            logger.debug("submitParam is not instanceof InputDateTimePicker component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return new InputDateTime();
        }
        InputDateTimePicker inputDateTimePicker = (InputDateTimePicker) submitParam;
        if (null == inputDateTimePicker.getType()) {
            return new InputDateTime();
        }
        InputDateTime inputDateTime = inputDateTimePicker.getDatetimeValue();
        if (inputDateTime == null) {
            return null;
        }
        dealDateTime(inputDateTime);
        inputDateTime.setType(inputDateTimePicker.getType());
        return inputDateTime;
    }

    private void dealDateTime(InputDateTime inputDateTime) {
        if (StringUtils.isNotBlank(inputDateTime.getMonth())) {
            inputDateTime.setMonth(buildDateTime(inputDateTime.getMonth()));
        }
        if (StringUtils.isNotBlank(inputDateTime.getDate())) {
            inputDateTime.setDate(buildDateTime(inputDateTime.getDate()));
        }
        if (StringUtils.isNotBlank(inputDateTime.getHour())) {
            inputDateTime.setHour(buildDateTime(inputDateTime.getHour()));
        }
        if (StringUtils.isNotBlank(inputDateTime.getMinute())) {
            inputDateTime.setMinute(buildDateTime(inputDateTime.getMinute()));
        }
    }

    private String buildDateTime(String time) {
        if (time.length() < 2) {
            if (time.length() == 1) {
                time = "0" + time;
                return time;
            } else {
                time = "00";
                return time;
            }
        }
        return time;
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {

    }
}
