package com.digiwin.mobile.mobileuibot.core.component.input.hidden;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;

import java.io.Serializable;

/**
 * <p>功能描述：隐藏数据组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputHidden
 * @Author: Zaregoto
 * @Date: 2021/11/10 19:57
 */
public class InputHidden extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = -7597146316174228117L;
    public static final String COMPONENT_TYPE = "INPUT_HIDDEN";

    private String text;

    public InputHidden() {
    }

    public static InputHidden createEmpty() {
        return create("");
    }

    public static InputHidden create(String text) {
        InputHidden inputHidden = new InputHidden();
        inputHidden.setText(text);

        return inputHidden;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override public String returnComponentType() {
        return InputHidden.COMPONENT_TYPE;
    }
}
