package com.digiwin.mobile.mobileuibot.core.component.input.hidden;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.location.InputLocation;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * <p>功能描述：隐藏数据组件参数解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputHiddenParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/11/10 19:59
 */
@Component("inputHiddenParamAnalyzer")
public class InputHiddenParamAnalyzer implements ComponentParamAnalyzer<InputHidden, String> {

    private static final Logger logger = LoggerFactory.getLogger(InputHiddenParamAnalyzer.class);

    @Override public String getComponentType() {
        return InputHidden.COMPONENT_TYPE;
    }

    @Override public Class<InputHidden> getSubmitParamType() {
        return InputHidden.class;
    }

    @Override public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputHidden)) {
            logger.debug("submitParam is not instanceof InputHidden component..."
                + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        InputHidden inputHidden = (InputHidden) submitParam;
        return Optional.ofNullable(inputHidden.getText()).orElse("");
    }

    @Override public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
        UiBotPageData pageData, Object... args) {

    }
}
