package com.digiwin.mobile.mobileuibot.core.component.input.location;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * @author zhangjj
 * @date 2021/11/4 0004 15:40
 */
@Component("inputLocationParamAnalyzer")
public class InputLocationParamAnalyzer implements ComponentParamAnalyzer<InputLocation, String> {
    Logger logger = LoggerFactory.getLogger(InputLocationParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputLocation.COMPONENT_TYPE;
    }

    @Override
    public Class<InputLocation> getSubmitParamType() {
        return InputLocation.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputLocation)) {
            logger.debug("submitParam is not instanceof InputLocation component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        InputLocation inputLocation = (InputLocation) submitParam;
        return Optional.ofNullable(inputLocation.getAddress()).orElse("");
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {

    }
}
