package com.digiwin.mobile.mobileuibot.core.component.input.multitext;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputMultiParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/5/25 20:25
 */
@Component("inputMultiParamAnalyzer")
public class InputMultiParamAnalyzer implements ComponentParamAnalyzer<InputMultiText, String> {

    private static final Logger logger = LoggerFactory.getLogger(InputMultiParamAnalyzer.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public String getComponentType() {
        return InputMultiText.COMPONENT_TYPE;
    }

    @Override
    public Class<InputMultiText> getSubmitParamType() {
        return InputMultiText.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputMultiText)) {
            logger.debug("submitParam is not instanceof InputMultiText component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        InputMultiText inputMultiText = (InputMultiText) submitParam;
        return Optional.ofNullable(inputMultiText.getText()).orElse("");
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {
        Map<String, Object> displayParam = (Map<String, Object>) pageData.get(pageDataKey);
        String placeholder = (String) displayParam.get("placeholder");
        Boolean required = (Boolean) displayParam.get("required");
        String text = (String) displayParam.get("text");
        String title = (String) displayParam.get("title");
//        if ("disagree".equals(apiRequest.getRawData().get("id"))) {
//            // 签核下 按钮不同意页面 签核意见必填（因为同意和不同意使用的是同一个页面，MongoDB配置是不必填，故不同意场景下特殊处理）
//            displayParam.put("required", true);
//        }

        // 处理多语言
        displayParam.put("placeholder", localeService.getLanguageValue(apiRequest.getLocale(), placeholder));
        displayParam.put("title", localeService.getLanguageValue(apiRequest.getLocale(), title));
    }
}
