package com.digiwin.mobile.mobileuibot.core.component.input.numeric;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputNumericParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/6/14 15:28
 */
@Component("inputNumericParamAnalyzer")
public class InputNumericParamAnalyzer implements ComponentParamAnalyzer<InputNumeric, Number> {
    private static final Logger logger = LoggerFactory.getLogger(InputNumericParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputNumeric.COMPONENT_TYPE;
    }

    @Override
    public Class<InputNumeric> getSubmitParamType() {
        return InputNumeric.class;
    }

    @Override
    public Number analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputNumeric)) {
            logger.debug("submitParam is not instanceof InputNumeric component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return null;
        }
        InputNumeric inputNumeric = (InputNumeric) submitParam;
        if (!StringUtils.hasLength(inputNumeric.getText())) {
            return null;
        }
        BigDecimal value = new BigDecimal(inputNumeric.getText());
        //v1转v2版  h5 web 处理
        if (ObjectUtils.isNotEmpty(inputNumeric.getCmptVersion()) && 2 == inputNumeric.getCmptVersion()) {
            return value;
        }
        if (InputNumericTypeEnum.PERCENTAGE.getValue().equals(inputNumeric.getType())) {
            return value.divide(new BigDecimal(100));
        } else if (InputNumericTypeEnum.INTEGER.getValue().equals(inputNumeric.getType())
                || InputNumericTypeEnum.INTEGER_ALLOW_NEGATIVE.getValue().equals(inputNumeric.getType())
                || InputNumericTypeEnum.DECIMAL_ALLOW_NEGATIVE.getValue().equals(inputNumeric.getType())
                || InputNumericTypeEnum.DECIMAL.getValue().equals(inputNumeric.getType())) {
            // FIXME 类型不正确，应该是更通用的一般类型。但这次6月时程太短，先以精度较高的Double来取，后面再改。
            return value;
        } else {
            return null;
        }
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {

    }
}
