package com.digiwin.mobile.mobileuibot.core.component.input.numeric;

/**
 * <p>功能描述：输入数值类型枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputNumericTypeEnum
 * @Author: Zaregoto
 * @Date: 2021/6/14 15:25
 */
public enum InputNumericTypeEnum {
    /**
     * 百分比
     */
    PERCENTAGE(1, "0.45"),

    /**
     * 整数
     */
    INTEGER(2, "13"),
    /**
     * 带单位的整数
     */
    INTEGERWITHUNIT(21, "13 个"),

    /**
     * 分数
     */
    FRACTION(3, "3/41"),

    /**
     * 科学计数
     */
    SCIENTIFICALLY(4, "1.2345678E-7"),

    /**
     * 可输入负数的整数
     */
    INTEGER_ALLOW_NEGATIVE(5, "-1"),

    /**
     * 可输入负数的小数
     */
    DECIMAL_ALLOW_NEGATIVE(6, "-1.2"),

    /**
     * 小数
     */
    DECIMAL(7, "0.1");

    private Integer value;
    private String exampleText;

    InputNumericTypeEnum(Integer value, String exampleText) {
        this.value = value;
        this.exampleText = exampleText;
    }

    public Integer getValue() {
        return value;
    }

    public String getExampleText() {
        return exampleText;
    }
}
