package com.digiwin.mobile.mobileuibot.core.component.input.ocr;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleMappingConfig;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.ocr.model.OcrData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableAttachmentColumnAttribute;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author wuyang
 * @date 20220221
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InputOcr extends Attachment<AttachmentRawDataDigiwinAthena> implements Serializable {

    private static final long serialVersionUID = -5849206980500061509L;
    public static final String COMPONENT_TYPE = "INPUT_OCR";


    /**
     * 卡片识别类型-- 0:身份证 1:银行卡
     */
    private Integer cardType;
    /**
     * 识别字段列表
     */
    private List<OcrData> dataList;
    /**
     * 请求后端的url
     */
    private String requestUrl;


    public static InputOcr create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList,
                                  Map<String, Object> bizData, List<Rule> mobileRuleList, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail){
        InputOcr inputOcr = new InputOcr();
        inputOcr.setRequestUrl("/mobile/v1/proxy/ocr/identification");
        List<UiBotTableColumn> columns = column.getColumns();
        boolean required = false;
        for(UiBotTableColumn tableColumn : columns){
            required = mobileRuleList.stream().filter(
                    rule -> rule.getSchema().equalsIgnoreCase(tableColumn.getSchema())
                            && rule.getCategory()
                            .equalsIgnoreCase(RuleCategoryEnum.VALIDATE.getCategory())
                            && rule.getType()
                            .equalsIgnoreCase(ValidateRuleTypeEnum.REQUIRED.getType()))
                    .findFirst().isPresent();
            if(required){
                break;
            }
        }
        String seachField = "";
        String path = "";
        for(Rule rule : mobileRuleList){
            //这边没填入ocrType需要修改
            if(rule.getMappingConfig() != null && column.getOcrType().equals(rule.getMappingConfig().getCardType())){
                RuleMappingConfig mappingConfig = rule.getMappingConfig();
                if(!StringUtils.isEmpty(mappingConfig.getPlaceholder())){
                    inputOcr.setPlaceholder(mappingConfig.getPlaceholder());
                }
                seachField = mappingConfig.getSearchFieldType();
                inputOcr.setSchema(rule.getSchema());
                inputOcr.setCardType(mappingConfig.getCardType());
                inputOcr.setDataList(mappingConfig.getDataList());
                if(rule.getPath() != null){
                    path = rule.getPath();
                }
                break;
            }
        }
        // 判断是否关闭aam同步
        boolean disableAam = Optional.ofNullable(column.getAttribute())
                .map(UiBotTableAttachmentColumnAttribute::getDisableAam)
                .orElse(false);
        Object data = bizData.get(column.getSchema());
        UiBotAttachment uiBotAttachment = JsonUtil.objectToJavaObject(data, UiBotAttachment.class);
        inputOcr.setRawData((AttachmentRawDataDigiwinAthena) Attachment.setAttachmentRawData(new Attachment<>(), Attachment.class, uiBotAttachment, locale,column,columnRuleList,digiwinAtmcBacklogDetail,disableAam, path).getRawData());
        for(OcrData ocrData : inputOcr.getDataList()){
            for(UiBotTableColumn column1 : columns){
                if(seachField.equals(column1.getType())){
                    inputOcr.setTitle(column1.getHeaderName());
                }
                if(ocrData.getMobileField().equals(column1.getSchema())){
                    ocrData.setFieldTitle(column1.getHeaderName());
                    break;
                }
            }
        }

        for(OcrData ocrData : inputOcr.getDataList()){
            ocrData.setFieldTitle(LocaleUtil.getMobileTextByDatabaseKey(locale, ocrData.getFieldTitle()));
        }

        return inputOcr;
    }

    @Override
    public String returnComponentType() {
        return InputOcr.COMPONENT_TYPE;
    }
}

