package com.digiwin.mobile.mobileuibot.core.component.input.picture;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.ComponentChoiceTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.*;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import lombok.Data;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * <p>功能描述：图片上传组件。支持图片展示、图片上传、图片删除、图片预览</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Picture
 * @Author: Zaregoto
 * @Date: 2021/7/27 17:52
 */
@Data
public class Picture extends Attachment<AttachmentRawDataDigiwinAthena> implements Serializable {
    private static final long serialVersionUID = -8651654674873293391L;
    public static final String COMPONENT_TYPE = "PICTURE";

    /**
     * 图片行数，默认为0行
     */
    private Integer rows = 0;
    /**
     * 图片列数，默认为3列
     */
    private Integer columns = 3;

    /**
     * 单选还是多选文件
     * 默认多选
     *
     * @see ComponentChoiceTypeEnum
     */
    private String fileChoice = ComponentChoiceTypeEnum.MULTIPLE_CHOICE.getValue();

    /**
     * 示意图
     */
    private List<String> schematicPics;

    /**
     * 是否使用预览地址
     */
    private Boolean usePreviewUrl;

    /**
     * 是否通用上传,通用上传指的是走远来上传逻辑，上传到dmc这样，为false时，将图片信息已base64方式存储 提交时统一交给接口
     */
    private Boolean commonUpload = true;

    /**
     * 描述
     */
    private String describe = "点击上传";

    /**
     * 展示样式，一行或多行 默认多行展示 1为单行，0为多行
     */
    private Integer displayStyle = 0;

    /**
     * 是否展示图片名称
     */
    Boolean showPictureName = false;

    {
        // 最大上传12
        this.limit = 12;
        //上传类型
        uploadTypes = new ArrayList<Integer>() {
            private static final long serialVersionUID = -7642929786163297837L;

            {
                add(AttachmentUploadTypeEnum.PICTURE.getValue());
                add(AttachmentUploadTypeEnum.VIDEO.getValue());
            }
        };

    }

    public Picture() {
    }

    public static Picture create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList,
                                 Map<String, Object> bizData, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail,
                                 List<Rule> mobileValidateRuleList, Boolean disableAam) {
        return Attachment.create(Picture.class, locale, column, columnRuleList, bizData,
                digiwinAtmcBacklogDetail, mobileValidateRuleList, disableAam);
    }

    public static Picture create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule) {
        Picture picture = new Picture();
        picture.setSchema(uiBotFieldLayout.getSchema());
        picture.setTitle(uiBotFieldLayout.getHeaderName());
        picture.setType(AttachmentTypeEnum.READ_AND_WRITE.getValue());

        picture.setRequired(false);
        if (uiBotRule != null) {
            picture.setRequired("required".equalsIgnoreCase(uiBotRule.getKey()));
        }
        //手动发起项目-问题反馈页面-「问题图片」设置最大个数限制「5」
        if ("question_info".equalsIgnoreCase(uiBotFieldLayout.getPath()) && "question_picture".equalsIgnoreCase(uiBotFieldLayout.getSchema())) {
            picture.setLimit(5);
        }

        AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
        if (uiBotFieldLayout.getAttribute() != null) {
            picture.setFileMaxSize(new FileMaxSize(uiBotFieldLayout.getAttribute().getLong("fileMaxSize")));
            attachmentRawDataDigiwinAthena.setDisableAam(uiBotFieldLayout.getAttribute().getBoolean("disableAam"));
            attachmentRawDataDigiwinAthena.setUploadCategory(uiBotFieldLayout.getAttribute().getString("uploadCategory"));
        }
        attachmentRawDataDigiwinAthena.setUploadCategoryId("");
        attachmentRawDataDigiwinAthena.setPath("");
        attachmentRawDataDigiwinAthena.setRowDataKey("");
        picture.setRawData(attachmentRawDataDigiwinAthena);
        return picture;
    }

    //工时回报定制图示生成
    public static Picture create(Map<String, Object> picAttachment, String locale, ApiRequest apiRequest) {
        Picture picture = new Picture();

        List<AttachmentFile> fileList = new ArrayList<>();
        //有值才会生成里面数据
        if (null != picAttachment.get("data")) {
            List<Map<String, Object>> picDataList = (List<Map<String, Object>>) picAttachment.get("data");
            Map<String, Object> firstPicData = new HashMap<>();
            if (!CollectionUtils.isEmpty(picDataList)) {
                firstPicData = picDataList.get(0);
                for (Map<String, Object> picData : picDataList) {
                    AttachmentFile attachmentFile = new AttachmentFile();
                    String fileName = String.valueOf(picData.get("name"));
                    //判断是否是图片，是图片才会新增进来
                    if (FileUtil.isImage(fileName)) {
                        attachmentFile.setFileExtension(FileUtil.getFileExtension(fileName));
                        attachmentFile.setFileId(String.valueOf(picData.get("id")));
                        attachmentFile.setFileName(fileName.substring(0, fileName.lastIndexOf('.')));
                        BigDecimal bigSize = BigDecimal.valueOf((Double) picData.get("size"));
                        attachmentFile.setFileSize(bigSize.longValue());
                        attachmentFile.setUploadTime(String.valueOf(picData.get("create_date")));
                        attachmentFile.setUploader(String.valueOf(picData.get("upload_user_name")));
                        fileList.add(attachmentFile);
                    }
                }
                picture.setFileList(fileList);
            }

            AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
//            attachmentRawDataDigiwinAthena.setBuckets();
//            attachmentRawDataDigiwinAthena.setDisableAam();
//            attachmentRawDataDigiwinAthena.setPath();
            attachmentRawDataDigiwinAthena.setRowDataKey(String.valueOf(picAttachment.get("row_data")));
            if (apiRequest.getExtraParameter() != null) {
                attachmentRawDataDigiwinAthena.setTmActivityId(apiRequest.getExtraParameter().getTmActivityId());
                attachmentRawDataDigiwinAthena.setTmTaskId(apiRequest.getExtraParameter().getTmTaskId());
            }
            attachmentRawDataDigiwinAthena.setUploadCategory(String.valueOf(firstPicData.get("category")));
            attachmentRawDataDigiwinAthena.setUploadCategoryId(String.valueOf(firstPicData.get("category_id")));
            picture.setRawData(attachmentRawDataDigiwinAthena);
        }

        return picture;
    }

    @Override
    public String returnComponentType() {
        return Picture.COMPONENT_TYPE;
    }

    /**
     * 仅仅用于测试代码
     *
     * @param schema
     * @return
     */
    public static Picture createStaticPic(String schema) {
        Picture picture = new Picture();
        picture.setSchema(schema);
        picture.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        picture.setRows(1);
        picture.setColumns(3);
        picture.setTitle("图片");
        picture.setRequired(false);
        picture.setMaxSize(204521L);
        AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
        picture.setRawData(attachmentRawDataDigiwinAthena);
        List<AttachmentFile> files = new ArrayList<>();
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        files.add(createStaticFile("https://dmc-hw-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/71d64b03-2226-479c-95d3-92d10fecf356", "9e225b38-1048-47e4-b905-2de5f1410ea6"));
        picture.setFileList(files);
        return picture;
    }

    public static Picture createEmptyPic(String schema, String title, Integer type, boolean required, String uploadCategory) {
        Picture picture = new Picture();
        picture.setSchema(schema);
        picture.setRequired(required);
        picture.setTitle(title);
        picture.setType(type);
        picture.setRows(0);
        picture.setColumns(3);
        AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
        attachmentRawDataDigiwinAthena.setDisableAam(true);
        attachmentRawDataDigiwinAthena.setUploadCategory(uploadCategory);
        attachmentRawDataDigiwinAthena.setUploadCategoryId("");
        attachmentRawDataDigiwinAthena.setPath("");
        attachmentRawDataDigiwinAthena.setRowDataKey("");
        attachmentRawDataDigiwinAthena.setBuckets(DigiwinDmcConfig.SRM_LOADING_BUCKET);
        picture.setRawData(attachmentRawDataDigiwinAthena);
        picture.setRawData(attachmentRawDataDigiwinAthena);
        picture.setLimit(3);
        return picture;
    }

    private static AttachmentFile createStaticFile(String url, String fileId) {
        AttachmentFile attachmentFile = new AttachmentFile();
        attachmentFile.setFileId(fileId);
        attachmentFile.setUploadTime("2022-08-10 13:28");
        attachmentFile.setShareUrl(url);
        attachmentFile.setFileName("icon-海昌海洋公园.jpg");
        attachmentFile.setFileSize(11730L);
        attachmentFile.setUploader("王芳（FRC900）");
        attachmentFile.setFileExtension("jpg");
        attachmentFile.setStatus("NEW");
        return attachmentFile;
    }

    public static Picture createZtbVehiclePic(String schema, String title, Integer type,
                                              List<String> schematicPics, Integer limit) {
        Picture picture = new Picture();
        picture.setSchema(schema);
        picture.setRequired(true);
        picture.setTitle(title);
        picture.setType(type);
        picture.setRows(0);
        picture.setColumns(0);
        AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
        attachmentRawDataDigiwinAthena.setDisableAam(true);
        attachmentRawDataDigiwinAthena.setUploadCategory("driver_vehicle_img");
        attachmentRawDataDigiwinAthena.setUploadCategoryId("");
        attachmentRawDataDigiwinAthena.setPath("");
        attachmentRawDataDigiwinAthena.setRowDataKey("");
        attachmentRawDataDigiwinAthena.setBuckets(DigiwinDmcConfig.SRM_LOADING_BUCKET);
        picture.setRawData(attachmentRawDataDigiwinAthena);
        picture.setSchematicPics(schematicPics);
        picture.setLimit(limit);
        return picture;
    }


    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        if (ObjectUtils.isNotEmpty(fileMaxSize)) {
            if (ObjectUtils.isEmpty(fileMaxSize.getImageMaxSize())) {
                fileMaxSize.setImageMaxSize(10l * 1024 * 1024);
            }
            if (ObjectUtils.isEmpty(fileMaxSize.getVideoMaxSize())) {
                fileMaxSize.setVideoMaxSize(100l * 1024 * 1024);
            }
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        Picture picture = new Picture();
        picture.setComponentId(rawContent.getComponentId());
        picture.setTitle(rawContent.getLabel());
        picture.setEnable(rawContent.getEditable());
        picture.setType(BooleanUtils.isTrue(rawContent.getEditable()) ? AttachmentTypeEnum.READ_AND_WRITE.getValue() : AttachmentTypeEnum.READ_ONLY.getValue());
        picture.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        Card.DesignerRawCard.Content.PictureObj pictureObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.PictureObj.class);
        if (pictureObj != null) {
            picture.setPlaceholder(pictureObj.getPlaceholder());
            picture.setLimit(pictureObj.getLimit());
            picture.setFileMaxSize(pictureObj.getFileMaxSize());
            picture.setUploadTypes(pictureObj.getUploadTypes());
            AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
            rawDataDigiwinAthena.setBuckets(pictureObj.getBuckets());
            if (pictureObj.getRawData() != null) {
                rawDataDigiwinAthena.setDisableAam(pictureObj.getRawData().getDisableAam());
                rawDataDigiwinAthena.setUploadCategory(pictureObj.getRawData().getUploadCategory());
            }
            picture.setRawData(rawDataDigiwinAthena);
            picture.setCommonUpload(pictureObj.getCommonUpload());
            picture.setShowPictureName(pictureObj.getShowPictureName());
            picture.setDescribe(pictureObj.getDescribe());
            picture.setDisplayStyle(pictureObj.getDisplayStyle());
        }
        picture.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return picture;
    }

}
