package com.digiwin.mobile.mobileuibot.core.component.input.picture;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachmentData;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * <p>功能描述：图片组件参数解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PictureParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/7/27 18:36
 */
@Component("pictureParamAnalyzer")
public class PictureParamAnalyzer implements ComponentParamAnalyzer<Picture, UiBotAttachment> {

    private static final Logger logger = LoggerFactory.getLogger(PictureParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return Picture.COMPONENT_TYPE;
    }

    @Override
    public Class<Picture> getSubmitParamType() {
        return Picture.class;
    }

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Override
    public UiBotAttachment analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof Picture)) {
            logger.debug("submitParam is not instanceof Picture component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return UiBotAttachment.createEmpty();
        }
        Picture picture = (Picture) submitParam;
        AttachmentRawDataDigiwinAthena attachmentRawData =
                (AttachmentRawDataDigiwinAthena) picture.getRawData();
        UiBotAttachment uiBotAttachment = new UiBotAttachment();
        // 会出现categoryId为空的情况，需要先查一下
        String uploadCategoryId = Optional.ofNullable(attachmentRawData.getUploadCategoryId()).orElse(
                this.digiwinDmcProxyService.getDirIdByName(attachmentRawData.getUploadCategory(),
                        Optional.ofNullable(attachmentRawData.getBuckets()).orElse(DigiwinDmcConfig.ATHENA_BUCKET))
        );
        picture.getFileList().forEach(obj -> {
            AttachmentFile attachmentFile = (AttachmentFile) obj;
            UiBotAttachmentData uiBotAttachmentData = new UiBotAttachmentData();
            uiBotAttachmentData.setId(attachmentFile.getFileId());
            uiBotAttachmentData.setName(attachmentFile.getFileName());
            uiBotAttachmentData.setUploadUserName(attachmentFile.getUploader());
            uiBotAttachmentData.setCreateDate(attachmentFile.getUploadTime());
            uiBotAttachmentData.setSize(attachmentFile.getFileSize().doubleValue());
            uiBotAttachmentData.setShareUrl(attachmentFile.getShareUrl());

            uiBotAttachmentData.setCategory(attachmentRawData.getUploadCategory());
            uiBotAttachmentData.setCategoryId(Optional.ofNullable(uploadCategoryId).orElse(""));
            uiBotAttachmentData.setRowDataKey(attachmentRawData.getRowDataKey());
            uiBotAttachmentData.setBase64Data(attachmentFile.getBase64Data());
            uiBotAttachmentData.setCoverBase64Data(attachmentFile.getCoverBase64Data());
            uiBotAttachmentData.setFileExtension(attachmentFile.getFileExtension());
            uiBotAttachmentData.setBase64DataId(attachmentFile.getBase64DataId());
            uiBotAttachment.addData(uiBotAttachmentData);
        });
        uiBotAttachment.setRowDataKey(attachmentRawData.getRowDataKey());

        return uiBotAttachment;
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {

    }
}
