package com.digiwin.mobile.mobileuibot.core.component.input.scan;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author zhangjj
 * @date 2021/12/14 0014 15:48
 */
public abstract class InputScan extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = 3300859534943372506L;

    private String title;
    private Map<String, Object> rawData;
    /**
     * 是否需要校验
     */
    private Boolean check;
    /**
     * 校验接口地址
     */
    private String checkUrl;
    /**
     * 校验需要传入的其他组件
     */
    private List<String> checkSchema;

    /**
     * 是否发布录入结果到监听器
     */
    private Boolean publishResult;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<String, Object> getRawData() {
        return rawData;
    }

    public void setRawData(Map<String, Object> rawData) {
        this.rawData = rawData;
    }

    public Boolean getCheck() {
        return check;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    public String getCheckUrl() {
        return checkUrl;
    }

    public void setCheckUrl(String checkUrl) {
        this.checkUrl = checkUrl;
    }

    public List<String> getCheckSchema() {
        return checkSchema;
    }

    public void setCheckSchema(List<String> checkSchema) {
        this.checkSchema = checkSchema;
    }

    public Boolean getPublishResult() {
        return publishResult;
    }

    public void setPublishResult(Boolean publishResult) {
        this.publishResult = publishResult;
    }
}
